/*
 * Decompiled with CFR 0.152.
 */
package com.dap.component.rocketmq.producer.handler;

import com.dap.component.rocketmq.DWRocketMQException;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerParam;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerResponse;
import com.dap.component.rocketmq.api.producer.DWRocketMQProducerTransactionAction;
import com.dap.component.rocketmq.producer.handler.DWRocketMQProducerBaseHandler;
import com.dap.component.rocketmq.producer.params.DWRocketMQProducerTransactionParam;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.apache.rocketmq.client.apis.producer.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWRocketMQProducerTransactionHandler
extends DWRocketMQProducerBaseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DWRocketMQProducerTransactionHandler.class);
    private DWRocketMQProducerTransactionAction transactionAction;

    @Override
    public <T> void sendMessage(String topic, String tag, Boolean enableAsync, DWRocketMQProducerParam<T> requestParam) {
        this.transactionAction = this.getTransactionAction(requestParam);
        super.sendMessage(topic, tag, enableAsync, requestParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSend(Boolean enableAsync, String topic, Message dwMessage) {
        DWRocketMQProducerResponse response;
        SendReceipt sendReceipt = null;
        Transaction transaction = null;
        Exception txException = null;
        boolean actionResult = false;
        try {
            Message message = super.convertMessage(dwMessage);
            try {
                transaction = super.getProducer().beginTransaction();
            }
            catch (ClientException e) {
                throw new DWRocketMQException("Begin transaction message error", e);
            }
            try {
                sendReceipt = super.getProducer().send(message, transaction);
            }
            catch (ClientException e) {
                throw new DWRocketMQException("Send transaction message error", e);
            }
        }
        catch (Exception e) {
            txException = e;
        }
        finally {
            try {
                super.invokeAfter(topic, dwMessage, txException);
            }
            catch (Exception ex) {
                LOGGER.error("Execute producer 'invokeAfter' failed after sync sending:{}", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
        if (Objects.isNull(sendReceipt) || Objects.isNull(sendReceipt.getMessageId())) {
            response = super.populateProducerResponse(sendReceipt, dwMessage);
            super.doResponseCallback(response, txException);
            return;
        }
        try {
            actionResult = this.transactionAction.doTransactionAction();
        }
        catch (Exception e) {
            throw new DWRocketMQException("Execute local transaction action error\uff1a" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (actionResult) {
            try {
                transaction.commit();
            }
            catch (ClientException e) {
                throw new DWRocketMQException("Commit transaction message error.", e);
            }
        }
        try {
            transaction.rollback();
        }
        catch (ClientException e) {
            throw new DWRocketMQException("Rollback transaction message error", e);
        }
        txException = new DWRocketMQException("Execute local transaction action failed and rollback transaction message.");
        response = super.populateProducerResponse(sendReceipt, dwMessage);
        if (Objects.nonNull(txException)) {
            response.setSuccess(Boolean.valueOf(false));
        }
        super.doResponseCallback(response, txException);
    }

    private <T> DWRocketMQProducerTransactionAction getTransactionAction(DWRocketMQProducerParam<T> requestParam) {
        if (!DWRocketMQProducerTransactionParam.class.isAssignableFrom(requestParam.getClass())) {
            throw new DWRocketMQException("'requestParam' must be instance of DWRocketMQProducerTransactionParam.");
        }
        DWRocketMQProducerTransactionParam transactionParam = (DWRocketMQProducerTransactionParam)requestParam;
        if (Objects.isNull(transactionParam.getTransactionAction())) {
            throw new DWRocketMQException("'transactionAction' must be not empty.");
        }
        return transactionParam.getTransactionAction();
    }
}

