/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.dbservice;

import com.dap.component.schedule.api.ScheduleConfigProvider;
import com.dap.component.schedule.api.ScheduleRequestContextProvider;
import com.dap.component.schedule.api.ScheduleThrowDWExceptionProvider;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.util.DWScheduleCastUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DWScheduleDBService {
    @Autowired
    private DWDao dao;
    private static String tenantSqlTag;
    private static String tenantColumnName;
    @Deprecated
    private final String querySQL = "select * from dw_schedule ";
    @Deprecated
    private final String updateSQL = "update  from dw_schedule ";
    private final String deleteSQL = "delete from dw_schedule where schedule_id = ? " + tenantSqlTag;
    private final String deleteCrossTenantSQL = "delete from dw_schedule where schedule_id = ? and " + tenantColumnName + " = ? ";
    private final String updateStatusSQL = "update dw_schedule set enable_status = ? where schedule_id = ? " + tenantSqlTag;
    private final String tableName = "dw_schedule";
    private static DWScheduleDBService instance;

    public static DWScheduleDBService getInstance() {
        if (instance == null && SpringContextUtils.containsBean((String)"DWScheduleDBService")) {
            instance = (DWScheduleDBService)SpringContextUtils.getBean((String)"DWScheduleDBService");
            ScheduleConfigProvider configProvider = (ScheduleConfigProvider)SpringContextUtils.getBean((String)"scheduleConfigProvider");
            String tenantTagByColumnName = configProvider.getTenantTagByColumnName();
            String tenantColumnName = configProvider.getTenantColumnName();
            tenantSqlTag = tenantTagByColumnName;
            DWScheduleDBService.tenantColumnName = tenantColumnName;
        }
        return instance;
    }

    public static void setInstance(DWScheduleDBService instance) {
        DWScheduleDBService.instance = instance;
    }

    public Object updateScheduleByDataSet(DWDataSet dataSet) throws Exception {
        return this.dao.execute(dataSet);
    }

    public int deleteSchedule(String scheduleId) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.deleteSQL, new Object[]{scheduleId});
    }

    public int deleteScheduleCrossTenant(String scheduleId, Object tenantid) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        option.setTenantEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.deleteCrossTenantSQL, new Object[]{scheduleId, tenantid});
    }

    public Object getScheduleList(DWPagableQueryInfo queryInfo) throws Exception {
        queryInfo.setTableName("dw_schedule");
        return this.dao.select((DWQueryInfo)queryInfo);
    }

    public DWDataRow getScheduleInfo(String scheduleId) throws Exception {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_schedule");
        queryInfo.addEqualInfo("schedule_id", (Object)scheduleId);
        return this.dao.selectOne(queryInfo, new DWDataSetOperationOption());
    }

    public int enableSchedule(String id) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.updateStatusSQL, new Object[]{"Y", id});
    }

    public int disableSchedule(String id) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.updateStatusSQL, new Object[]{"N", id});
    }

    public DWScheduleQuartzInfo queryDWScheduleQuartzInfo(String scheduleId) throws Exception {
        DWScheduleQuartzInfo quartzInfo = null;
        DWDataRow scheduleInfo = this.getScheduleInfo(scheduleId);
        if (scheduleInfo != null) {
            quartzInfo = DWScheduleCastUtils.convertDataRowToScheduleQuartzInfo(scheduleInfo);
        }
        return quartzInfo;
    }

    public void assertExistedSchedule(List<String> scheduleIds) throws Exception {
        ArrayList<String> scheduleLst = new ArrayList<String>(scheduleIds);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        DWQueryInfo queryInfo = new DWQueryInfo("dw_schedule");
        DWQueryCondition condition = new DWQueryCondition();
        condition.addFieldInfo("schedule_id", DWQueryValueOperator.In, scheduleLst.toArray());
        queryInfo.setCondition(condition);
        DWDataSet result = this.dao.select(queryInfo, option);
        DWDataRowCollection rows = result.getTable("dw_schedule").getRows();
        for (DWDataRow row : rows) {
            scheduleLst.remove(row.get("schedule_id"));
        }
        if (scheduleLst.size() > 0) {
            ScheduleThrowDWExceptionProvider throwDWExceptionProvider = (ScheduleThrowDWExceptionProvider)SpringContextUtils.getBean((String)"scheduleThrowDWExceptionProvider");
            throwDWExceptionProvider.exec("15001", scheduleLst.toArray());
        }
    }

    public DWDataRowCollection getHotScheduleInfos() {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_schedule");
        queryInfo.addEqualInfo("is_hot", (Object)true);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        option.setTenantEnabled(false);
        ScheduleRequestContextProvider requestContextProvider = (ScheduleRequestContextProvider)SpringContextUtils.getBean((String)"scheduleRequestContextProvider");
        requestContextProvider.setProfile(new HashMap<String, Object>());
        DWDataSet result = this.dao.select(queryInfo, option);
        return result.getTable("dw_schedule").getRows();
    }

    public DWDataRowCollection getNormalScheduleInfos() {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_schedule");
        queryInfo.addEqualInfo("is_hot", null);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        option.setTenantEnabled(false);
        DWDataSet result = this.dao.select(queryInfo, option);
        return result.getTable("dw_schedule").getRows();
    }

    public DWDataRowCollection getDeleteScheduleInfos(DWQueryCondition condition) {
        DWQueryInfo queryInfo = new DWQueryInfo();
        queryInfo.setTableName("dw_schedule");
        queryInfo.setCondition(condition);
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        DWDataSet result = this.dao.select(queryInfo, option);
        return result.getTable("dw_schedule").getRows();
    }

    public static void setTenantColumnName(String tenantTagByColumnName) {
        tenantColumnName = tenantTagByColumnName;
    }

    public static void setTenantSqlTag(String tenantSqlTag) {
        DWScheduleDBService.tenantSqlTag = tenantSqlTag;
    }

    static {
        instance = null;
    }
}

