/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.dbservice;

import com.dap.component.schedule.api.ScheduleConfigProvider;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.module.spring.SpringContextUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DWScheduleContactDBService {
    @Autowired
    private DWDao dao;
    private static String tenantSqlTag;
    private static String tenantColumnName;
    private final String querySQL = "select * from dw_schedule_contact where schedule_id = ? " + tenantSqlTag;
    private final String deleteSQL = "delete from dw_schedule_contact where schedule_id = ? " + tenantSqlTag;
    private final String deleteCrossTenantSQL = "delete from dw_schedule_contact where schedule_id = ?   and " + tenantColumnName + " = ? ";
    private static DWScheduleContactDBService instance;

    public static DWScheduleContactDBService getInstance() {
        if (instance == null && SpringContextUtils.containsBean((String)"DWScheduleContactDBService")) {
            instance = (DWScheduleContactDBService)SpringContextUtils.getBean((String)"DWScheduleContactDBService");
            ScheduleConfigProvider configProvider = (ScheduleConfigProvider)SpringContextUtils.getBean((String)"scheduleConfigProvider");
            String tenantTagByColumnName = configProvider.getTenantTagByColumnName();
            String tenantColumnName = configProvider.getTenantColumnName();
            tenantSqlTag = tenantTagByColumnName;
            DWScheduleContactDBService.tenantColumnName = tenantColumnName;
        }
        return instance;
    }

    public static void setInstance(DWScheduleContactDBService instance) {
        DWScheduleContactDBService.instance = instance;
    }

    public int deleteScheduleContact(String scheduleId) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.deleteSQL, new Object[]{scheduleId});
    }

    public int deleteScheduleContactCrossTenant(String scheduleId, Object tenantId) throws Exception {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setManagementFieldEnabled(false);
        option.setTenantEnabled(false);
        return this.dao.update((IDWSQLOptions)option, this.deleteCrossTenantSQL, new Object[]{scheduleId, tenantId});
    }

    public Object queryScheduleContactList(String scheduleId) throws Exception {
        return this.dao.select(this.querySQL, new Object[]{scheduleId});
    }

    public static void setTenantColumnName(String tenantTagByColumnName) {
        tenantColumnName = tenantTagByColumnName;
    }

    public static void setTenantSqlTag(String tenantSqlTag) {
        DWScheduleContactDBService.tenantSqlTag = tenantSqlTag;
    }

    static {
        instance = null;
    }
}

