/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz;

import com.digiwin.app.schedule.entity.UpdateBatchPojo;
import com.digiwin.app.schedule.quartz.Quartz;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.matchers.GroupMatcher;

public abstract class BaseQuartz
implements Quartz {
    private static final String CLASS_TAG = "[DWSchedule.Quartz]";
    private static final Log log = LogFactory.getLog(BaseQuartz.class);

    @Override
    public void addJob(JobDetail jobDetail) throws Exception {
        this.getScheduler().addJob(jobDetail, true, true);
    }

    @Override
    public void triggerJob(JobKey jobkey) {
        try {
            this.getScheduler().triggerJob(jobkey);
        }
        catch (SchedulerException e) {
            DWScheduleExceptionUtils.log(log, CLASS_TAG, (Exception)((Object)e));
        }
    }

    @Override
    public void scheduleJob(Trigger trigger, JobDetail jobDetail) throws Exception {
        try {
            this.getScheduler().scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            if (e.getMessage() != null && e.getMessage().endsWith("' will never fire.")) {
                log.warn((Object)("[DWSchedule.Quartz] " + e.getMessage()));
            }
            throw e;
        }
    }

    @Override
    public void scheduleJob(Set<Trigger> triggers, JobDetail jobDetail) throws Exception {
        this.getScheduler().scheduleJob(jobDetail, triggers, true);
    }

    @Override
    public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs) throws Exception {
        this.getScheduler().scheduleJobs(triggersAndJobs, true);
    }

    @Override
    public void deleteBeforeStoreJobsAndTriggers(List<UpdateBatchPojo> updateBatchPojos) throws Exception {
        this.getScheduler().deleteBeforeStoreJobsAndTriggers(updateBatchPojos, true);
    }

    @Override
    public void unScheduleJob(String jobName, String groupName) throws Exception {
        JobKey key = new JobKey(jobName, groupName);
        List triggers = this.getScheduler().getTriggersOfJob(key);
        if (triggers.size() > 0) {
            for (int i = 0; i < triggers.size(); ++i) {
                this.getScheduler().unscheduleJob(((Trigger)triggers.get(i)).getKey());
            }
        }
    }

    @Override
    public boolean deleteJob(String groupName) {
        boolean result = false;
        try {
            Set jobKeys = this.getScheduler().getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            if (jobKeys != null && jobKeys.size() > 0) {
                for (JobKey jobKey : jobKeys) {
                    if (this.getScheduler().deleteJob(jobKey)) {
                        result = true;
                        continue;
                    }
                    result = false;
                }
            } else {
                result = true;
            }
        }
        catch (SchedulerException e) {
            DWScheduleExceptionUtils.log(log, CLASS_TAG, (Exception)((Object)e));
        }
        return result;
    }

    @Override
    public boolean deleteJob(JobKey jobKey) {
        try {
            return this.getScheduler().deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            DWScheduleExceptionUtils.log(log, CLASS_TAG, (Exception)((Object)e));
            return false;
        }
    }

    @Override
    public boolean updateJobData(JobKey jobkey, Map<String, Object> newJobDataMap) throws Exception {
        JobDetailImpl jobDetail = (JobDetailImpl)this.getScheduler().getJobDetail(jobkey);
        if (jobDetail != null) {
            jobDetail.setDurability(true);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            for (Map.Entry<String, Object> newJobData : newJobDataMap.entrySet()) {
                jobDataMap.put(newJobData.getKey().toString(), newJobData.getValue());
            }
            this.getScheduler().addJob((JobDetail)jobDetail, true);
        }
        return true;
    }
}

