/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz.listener;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.schedule.context.DWScheduleContext;
import com.digiwin.app.schedule.quartz.multi.DataSourceProvider;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import com.digiwin.app.schedule.util.DWScheduleMailUtils;
import com.digiwin.app.schedule.util.DWScheduleServiceContextUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.impl.StdScheduler;
import org.quartz.listeners.TriggerListenerSupport;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DWJobInterruptListener
extends TriggerListenerSupport
implements SchedulerPlugin {
    private static final String CLASS_TAG = "[DWSchedule.DWQuartzJobListener]";
    private static Log log = LogFactory.getLog(DWJobInterruptListener.class);
    private long defalutMaxRuntime = 30L;
    private String name = "DWJobInterruptListener";
    private ScheduledExecutorService executor;
    private static ThreadLocal<ScheduledFuture<?>> localFuture = new ThreadLocal();
    private Scheduler scheduler;
    private static final String JOB_INTERRUPT_MONITOR_KEY = "JOB_INTERRUPT_MONITOR_KEY";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

    private void setFuture(ScheduledFuture<?> future) {
        localFuture.set(future);
    }

    private boolean cancelFuture(boolean mayInterruptIfRunning) {
        boolean result = false;
        ScheduledFuture<?> future = localFuture.get();
        if (future != null) {
            localFuture.remove();
            result = future.cancel(mayInterruptIfRunning);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void initialize(String name, Scheduler scheduler, ClassLoadHelper helper) throws SchedulerException {
        this.name = name;
        this.executor = Executors.newScheduledThreadPool(1);
        scheduler.getContext().put(JOB_INTERRUPT_MONITOR_KEY, (Object)this);
        this.scheduler = scheduler;
        this.scheduler.getListenerManager().addTriggerListener((TriggerListener)this);
    }

    public ScheduledFuture scheduleJobInterruptMonitor(String dataSource, JobKey jobkey, long delay, String executeId) {
        DWScheduleContext scheduleContext = DWScheduleContext.getInstance(dataSource);
        return this.executor.schedule(new InterruptMonitor(jobkey, this.scheduler, scheduleContext, executeId), delay, TimeUnit.MINUTES);
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        try {
            String dataSource;
            DWJobInterruptListener listener = (DWJobInterruptListener)((Object)context.getScheduler().getContext().get((Object)JOB_INTERRUPT_MONITOR_KEY));
            long jobDataDelay = this.defalutMaxRuntime;
            if (context.getJobDetail().getJobDataMap().get((Object)"max_runtime") != null) {
                jobDataDelay = context.getJobDetail().getJobDataMap().getLong("max_runtime");
            }
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            String scheduleId = jobDataMap.getString("schedule_id");
            String executeId = sdf.format(new Date()) + "-" + scheduleId;
            jobDataMap.put("execute_id", executeId);
            Scheduler scheduler = context.getScheduler();
            try {
                dataSource = DataSourceProvider.get((StdScheduler)scheduler);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new SchedulerException((Throwable)e);
            }
            this.setFuture(listener.scheduleJobInterruptMonitor(dataSource, context.getJobDetail().getKey(), jobDataDelay, executeId));
            log.debug((Object)("Job's Interrupt Monitor has been scheduled to interrupt with the delay :" + this.defalutMaxRuntime));
        }
        catch (SchedulerException e) {
            log.info((Object)("Error scheduling interrupt monitor " + e.getMessage()), (Throwable)e);
        }
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        this.cancelFuture(true);
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String executeState = jobDataMap.getString("execute_status");
        Object contactList = jobDataMap.get((Object)"contact_list");
        try {
            DWScheduleMailUtils.sendEmail(contactList, executeState);
        }
        catch (Exception e) {
            DWScheduleExceptionUtils.log(log, CLASS_TAG, e);
        }
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        if (jobDataMap.containsKey((Object)"is_allow_concurrent") && !"Y".equalsIgnoreCase((String)jobDataMap.get((Object)"is_allow_concurrent"))) {
            JobKey jobKey = context.getJobDetail().getKey();
            Scheduler scheduler = context.getScheduler();
            try {
                List excutingJobs = scheduler.getCurrentlyExecutingJobs();
                for (JobExecutionContext jobContext : excutingJobs) {
                    if (!jobContext.getJobDetail().getKey().equals((Object)jobKey)) continue;
                    String message = jobKey + " is already running.";
                    log.info((Object)message);
                    this.cancelFuture(true);
                    return true;
                }
            }
            catch (SchedulerException e) {
                DWScheduleExceptionUtils.log(log, CLASS_TAG, (Exception)((Object)e));
            }
        }
        return false;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void start() {
    }

    public long getDefalutMaxRuntime() {
        return this.defalutMaxRuntime;
    }

    public void setDefalutMaxRuntime(long defalutMaxRuntime) {
        this.defalutMaxRuntime = defalutMaxRuntime;
    }

    static class InterruptMonitor
    implements Runnable {
        private final JobKey jobKey;
        private final Scheduler scheduler;
        private final DWScheduleContext scheduleContext;
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final String exeCuteId;

        InterruptMonitor(JobKey jobKey, Scheduler scheduler, DWScheduleContext scheduleContext, String exeCuteId) {
            this.jobKey = jobKey;
            this.scheduler = scheduler;
            this.scheduleContext = scheduleContext;
            this.exeCuteId = exeCuteId;
        }

        @Override
        public void run() {
            try {
                this.log.info("Interrupting Job as it ran more than the configured max time. Job Details [" + this.jobKey.getName() + ":" + this.jobKey.getGroup() + "]");
                JobDataMap jobDataMap = this.scheduler.getJobDetail(this.jobKey).getJobDataMap();
                DWScheduleServiceContextUtil.initProfile(jobDataMap);
                String scheduleId = jobDataMap.getString("schedule_id");
                DWDataSet dataSet = new DWDataSet();
                DWDataRow row = dataSet.newTable("dw_schedule_record").newRow();
                row.set("execute_id", (Object)this.exeCuteId);
                row.set("schedule_id", (Object)scheduleId);
                row.set("execute_status", (Object)"interrupt");
                row.set("end_time", (Object)new Timestamp(new Date().getTime()));
                row.set("$state", (Object)"U");
                DWDataRow scheduleRow = dataSet.newTable("dw_schedule").newRow();
                scheduleRow.set("schedule_id", (Object)scheduleId);
                scheduleRow.set("recent_status", (Object)"interrupted");
                scheduleRow.set("$state", (Object)"U");
                this.scheduleContext.updateScheduleAndRecordByDataSet(dataSet);
                this.scheduler.interrupt(this.jobKey);
            }
            catch (Exception ex) {
                this.log.info("Error interrupting Job: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

