/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz;

import com.digiwin.app.schedule.quartz.DWCalendarIntervalScheduleBuilder;
import com.digiwin.app.schedule.quartz.DWSimpleScheduleBuilder;
import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.RecurrenceRuleScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class TriggerService {
    public static Trigger createTrigger(String triggerName, String groupName, String cronExpression, int misfirePolicy, JobDataMap jobData) {
        Trigger trigger;
        switch (misfirePolicy) {
            case -1: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionIgnoreMisfires()).usingJobData(jobData).build();
                break;
            }
            case 2: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionDoNothing()).usingJobData(jobData).build();
                break;
            }
            case 1: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionFireAndProceed()).usingJobData(jobData).build();
                break;
            }
            case 0: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).usingJobData(jobData).build();
                break;
            }
            default: {
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).usingJobData(jobData).build();
            }
        }
        return trigger;
    }

    public static JobDetail createJobDetail(String jobName, String groupName, JobDataMap jobDataMap, Class<? extends Job> jobClass) throws ClassNotFoundException {
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, groupName).setJobData(jobDataMap).build();
        return jobDetail;
    }

    public static Trigger createCalendarTrigger(String triggerName, String groupName, int timeInterval, DateBuilder.IntervalUnit unit, Date startTime, Date endTime, JobDataMap jobData) {
        Trigger trigger = null;
        DWCalendarIntervalScheduleBuilder cb = new DWCalendarIntervalScheduleBuilder();
        cb.withInterval(timeInterval, unit);
        trigger = endTime != null ? TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)cb).startAt(startTime).endAt(endTime).usingJobData(jobData).build() : TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)cb).startAt(startTime).usingJobData(jobData).build();
        return trigger;
    }

    public static Trigger createSimpleTrigger(String triggerName, String groupName, int timeInterval, DateBuilder.IntervalUnit unit, Date startTime, Date endTime, Integer repeat, JobDataMap jobData) {
        Trigger trigger = null;
        DWSimpleScheduleBuilder ssb = new DWSimpleScheduleBuilder();
        switch (unit) {
            case MINUTE: {
                ssb.withIntervalInMinutes(timeInterval);
                break;
            }
            case HOUR: {
                ssb.withIntervalInHours(timeInterval);
                break;
            }
            case DAY: {
                ssb.withIntervalInHours(24 * timeInterval);
                break;
            }
        }
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)ssb.withRepeatCount(repeat)).startAt(startTime).usingJobData(jobData);
        if (endTime != null) {
            builder.endAt(endTime);
        }
        trigger = builder.build();
        return trigger;
    }

    public static Trigger createRecurrenceRuleTrigger(String triggerName, String groupName, String rrule, Date startTime, Date endTime, JobDataMap jobData) {
        RecurrenceRuleScheduleBuilder builder = RecurrenceRuleScheduleBuilder.recurrenceRuleSchedule(rrule);
        return TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)builder).startAt(startTime).endAt(endTime).usingJobData(jobData).build();
    }
}

