/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import com.dap.component.schedule.api.ScheduleConfigProvider;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.context.DWScheduleContext;
import com.digiwin.app.schedule.entity.UpdateBatchPojo;
import com.digiwin.app.schedule.quartz.RedisTemplateHolder;
import com.digiwin.app.schedule.quartz.jdbcjobstore.DWJobStore;
import com.digiwin.app.schedule.quartz.multi.DataSourceProvider;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class DWQuartzScheduler
extends QuartzScheduler {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public DWQuartzScheduler(QuartzSchedulerResources resources, long idleWaitTime, long dbRetryInterval) throws SchedulerException {
        super(resources, idleWaitTime, dbRetryInterval);
    }

    public void deleteBeforeStoreJobsAndTriggers(List<UpdateBatchPojo> updateBatchPojos, boolean replace) throws SchedulerException {
        QuartzSchedulerResources resources;
        Field field;
        this.validateState();
        try {
            field = DWQuartzScheduler.class.getSuperclass().getDeclaredField("resources");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new SchedulerException((Throwable)e);
        }
        field.setAccessible(true);
        try {
            resources = (QuartzSchedulerResources)field.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new SchedulerException((Throwable)e);
        }
        DWJobStore jobStore = (DWJobStore)resources.getJobStore();
        jobStore.deleteBeforeStoreJobsAndTriggers(updateBatchPojos, replace);
        this.notifySchedulerThread(0L);
        for (UpdateBatchPojo updateBatchPojo : updateBatchPojos) {
            Map<JobDetail, Set<? extends Trigger>> triggersAndJobs = updateBatchPojo.getTriggersAndJobs();
            for (JobDetail jobDetail : triggersAndJobs.keySet()) {
                Set jobKeys;
                JobKey key = jobDetail.getKey();
                int scheduleType = updateBatchPojo.getScheduleType();
                if (1 == scheduleType) {
                    List triggers = resources.getJobStore().getTriggersForJob(key);
                    if (triggers.size() <= 0) continue;
                    for (int i = 0; i < triggers.size(); ++i) {
                        this.notifySchedulerListenersUnscheduled(((Trigger)triggers.get(i)).getKey());
                    }
                    continue;
                }
                String scheduleId = updateBatchPojo.getScheduleId();
                GroupMatcher matcher = GroupMatcher.jobGroupEquals((String)scheduleId);
                if (matcher == null) {
                    matcher = GroupMatcher.groupEquals((String)"DEFAULT");
                }
                if ((jobKeys = resources.getJobStore().getJobKeys(matcher)) == null || jobKeys.size() <= 0) continue;
                for (JobKey jobKey : jobKeys) {
                    this.notifySchedulerListenersJobDeleted(jobKey);
                }
            }
            for (Map.Entry entry : triggersAndJobs.entrySet()) {
                JobDetail job = (JobDetail)entry.getKey();
                if (job == null) continue;
                this.notifySchedulerListenersJobAdded(job);
                Set triggers = (Set)entry.getValue();
                if (triggers == null) continue;
                for (Trigger trigger : triggers) {
                    this.notifySchedulerThread(trigger.getNextFireTime().getTime());
                    this.notifySchedulerListenersSchduled(trigger);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SchedulerException {
        Object lock = new Object();
        if (DistributedScheduleUtils.isWorker()) {
            Thread publishOnlineThread = new Thread(this.publishOnline(lock));
            publishOnlineThread.setDaemon(true);
            try {
                Object object = lock;
                synchronized (object) {
                    Executors.newSingleThreadExecutor().execute(publishOnlineThread);
                    lock.wait();
                    super.start();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (DistributedScheduleUtils.isMaster()) {
            String dataSource;
            try {
                dataSource = DataSourceProvider.get(this);
            }
            catch (Exception e) {
                throw new SchedulerException((Throwable)e);
            }
            Thread assignScheduleThread = new Thread(this.assignSchedule(lock, dataSource));
            assignScheduleThread.setDaemon(true);
            try {
                Object object = lock;
                synchronized (object) {
                    Executors.newSingleThreadExecutor().execute(assignScheduleThread);
                    lock.wait();
                    super.start();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            super.start();
        }
    }

    private Runnable publishOnline(final Object lock) {
        Runnable t = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DWQuartzScheduler.this.log.info("distributed schedule worker heartbeat start");
                ScheduleConfigProvider configProvider = (ScheduleConfigProvider)SpringContextUtils.getBean((String)"scheduleConfigProvider");
                long keyExpireTime = configProvider.getWorkerTimeout("30");
                long heartbeatInterval = configProvider.getWorkerHeartbeatInterval("5");
                long reconnectInterval = configProvider.getWorkerReconnectInterval("60");
                String workerId = DistributedScheduleUtils.getWorkerId();
                try {
                    DefaultRedisScript defaultRedisScript0 = new DefaultRedisScript();
                    defaultRedisScript0.setScriptText("redis.call('publish', KEYS[2],ARGV[3]); redis.call('setEx', KEYS[1],ARGV[1],ARGV[2]); ");
                    List<String> keyList0 = Arrays.asList(workerId, "onlineWorkers");
                    String workerUrl = "http://" + InetAddress.getLocalHost().getHostAddress() + ":" + configProvider.getServerPort();
                    RedisTemplateHolder.redisTemplate.execute((RedisScript)defaultRedisScript0, keyList0, new Object[]{keyExpireTime, workerUrl, workerId});
                    RedisTemplateHolder.redisTemplate.keys((Object)"DWQuartz::worker::*").forEach(item -> DistributedScheduleUtils.onlineWorkers.put(item, RedisTemplateHolder.redisTemplate.opsForValue().get(item)));
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                    DefaultRedisScript defaultRedisScript = new DefaultRedisScript();
                    defaultRedisScript.setScriptText("if redis.call('exists', KEYS[1]) == 0 then redis.call('publish', KEYS[2],ARGV[3]); end; redis.call('setEx', KEYS[1],ARGV[1],ARGV[2]); ");
                    List<String> keyList = Arrays.asList(workerId, "onlineWorkers");
                    while (!Thread.currentThread().isInterrupted()) {
                        RedisTemplateHolder.redisTemplate.execute((RedisScript)defaultRedisScript, keyList, new Object[]{keyExpireTime, workerUrl, workerId});
                        Thread.sleep(heartbeatInterval * 1000L);
                    }
                }
                catch (IllegalStateException | QueryTimeoutException | RedisConnectionFailureException e) {
                    try {
                        DistributedScheduleUtils.onlineWorkers.clear();
                        DWQuartzScheduler.this.log.error("distributed schedule worker heartbeat fail, connect timeout", e);
                        Thread.sleep(reconnectInterval);
                        Thread publishOnlineThread = new Thread(DWQuartzScheduler.this.publishOnline(lock));
                        publishOnlineThread.setDaemon(true);
                        Executors.newSingleThreadExecutor().execute(publishOnlineThread);
                    }
                    catch (InterruptedException ex) {
                        DWQuartzScheduler.this.log.error("distributed schedule worker heartbeat reconnect interrupted", (Throwable)ex);
                    }
                }
                catch (Exception e) {
                    DWQuartzScheduler.this.log.error("distributed schedule worker stop", (Throwable)e);
                }
            }
        };
        return t;
    }

    private Runnable assignSchedule(final Object lock, final String dataSource) {
        Runnable t = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DWScheduleContext scheduleContext = DWScheduleContext.getInstance(dataSource);
                DWDataRowCollection hotScheduleInfos = scheduleContext.getHotScheduleInfos();
                hotScheduleInfos.forEach(hotSchedule -> {
                    String executeWorker = RedisTemplateHolder.redisTemplate.opsForList().leftPop((Object)"DWQuartz::subscribe::workers").toString();
                    RedisTemplateHolder.redisTemplate.opsForList().rightPush((Object)"DWQuartz::subscribe::workers", (Object)executeWorker);
                    RedisTemplateHolder.redisTemplate.opsForHash().put((Object)"DWQuartz::config::executors", hotSchedule.get("schedule_id"), (Object)executeWorker);
                });
                DWDataRowCollection normalScheduleInfos = scheduleContext.getNormalScheduleInfos();
                normalScheduleInfos.forEach(normalSchedule -> {
                    String executeWorker = RedisTemplateHolder.redisTemplate.opsForList().leftPop((Object)"DWQuartz::subscribe::workers").toString();
                    RedisTemplateHolder.redisTemplate.opsForList().rightPush((Object)"DWQuartz::subscribe::workers", (Object)executeWorker);
                    RedisTemplateHolder.redisTemplate.opsForHash().put((Object)"DWQuartz::config::executors", normalSchedule.get("schedule_id"), (Object)executeWorker);
                });
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        };
        return t;
    }
}

