/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.service;

import com.dap.component.schedule.api.ScheduleConfigProvider;
import com.dap.component.schedule.api.ScheduleRequestContextProvider;
import com.dap.component.schedule.api.ScheduleServiceProvider;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.dataobject.ScheduleTimeDO;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.quartz.DWQuartz;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobKey;

public class DWJobService {
    private DWQuartz quartz = DWQuartz.getInstance();
    private static DWJobService instance = null;
    private List<String> jobList = null;
    private static Boolean tenantEnabled = null;
    private static String tenantColumnName = null;
    private static String IAM_TENANTSID = "tenantSid";
    private static String IAM_USERID = "userId";

    public static DWJobService getInstance() {
        if (instance == null) {
            instance = new DWJobService();
        }
        return instance;
    }

    public Object getAvailableJobList() throws Exception {
        if (this.jobList != null) {
            return this.jobList;
        }
        ScheduleServiceProvider serviceProvider = (ScheduleServiceProvider)SpringContextUtils.getBean((String)"scheduleServiceProvider");
        this.jobList = serviceProvider.getAvailableJobList();
        return this.jobList;
    }

    public void executeJob(String jobName, String gruop) {
        JobKey jobkey = JobKey.jobKey((String)jobName, (String)gruop);
        this.quartz.triggerJob(jobkey);
    }

    public JobDataMap getJobDataMap(DWScheduleQuartzInfo quartzInfo) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("schedule_id", quartzInfo.getScheduleId());
        jobDataMap.put("job_name", quartzInfo.getJobName());
        jobDataMap.put("max_runtime", quartzInfo.getMaxRuntime());
        jobDataMap.put("schedule_param", quartzInfo.getScheduleParam());
        jobDataMap.put("schedule_type", quartzInfo.getScheduleType());
        jobDataMap.put("enable_status", quartzInfo.getEnableStatus());
        jobDataMap.put("contact_list", quartzInfo.getContactList());
        jobDataMap.put("module_name", quartzInfo.getModuleName());
        jobDataMap.put("program_code", quartzInfo.getProgramCode());
        jobDataMap.put("schedule_name", quartzInfo.getScheduleName());
        jobDataMap.put("module_name", quartzInfo.getModuleName());
        jobDataMap.put("is_allow_concurrent", quartzInfo.getDetail().getIsAllowConcurrent());
        ScheduleTimeDO detail = quartzInfo.getDetail();
        jobDataMap.put("exclude_date", detail.getExcludeDate());
        jobDataMap.put("exclude_time", detail.getExcludeTime());
        jobDataMap.put("is_retry", detail.getIsRetry());
        ScheduleRequestContextProvider requestContextProvider = (ScheduleRequestContextProvider)SpringContextUtils.getBean((String)"scheduleRequestContextProvider");
        Map<String, Object> profile = requestContextProvider.getProfile();
        if (profile != null && profile.size() > 0) {
            if (profile.containsKey(IAM_USERID)) {
                String userId = (String)profile.get(IAM_USERID);
                jobDataMap.put("dw_schedule_exec_userid", userId);
            }
            if (tenantEnabled == null) {
                ScheduleConfigProvider configProvider = (ScheduleConfigProvider)SpringContextUtils.getBean((String)"scheduleConfigProvider");
                tenantEnabled = configProvider.isTenantEnabled();
            }
            if (tenantEnabled.booleanValue()) {
                this.processTenant(jobDataMap, profile);
            }
        } else {
            throw new DWDataException(String.format("[DWSchedule]DWJobService.getJobDataMap: profile is null or empty in multi-tenancy env.", new Object[0]));
        }
        return jobDataMap;
    }

    private void processTenant(JobDataMap jobDataMap, Map<String, Object> profile) {
        Long tenantSid;
        if (profile.containsKey(IAM_TENANTSID)) {
            tenantSid = (Long)profile.get(IAM_TENANTSID);
            if (tenantColumnName == null) {
                ScheduleConfigProvider configProvider = (ScheduleConfigProvider)SpringContextUtils.getBean((String)"scheduleConfigProvider");
                tenantColumnName = configProvider.getTenantColumnName();
            }
        } else {
            throw new DWDataException(String.format("[DWSchedule]DWJobService.getJobDataMap: %s is missing in profile", IAM_TENANTSID));
        }
        jobDataMap.put(tenantColumnName, (Object)tenantSid);
        if (profile.containsKey("tenantId")) {
            String tenantId = String.valueOf(profile.get("tenantId"));
            jobDataMap.put("tenantId", tenantId);
        }
    }
}

