/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.util;

import com.digiwin.app.schedule.DWScheduleProperties;
import com.digiwin.app.schedule.dataobject.ScheduleContactDO;
import com.digiwin.utils.DWMailUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWScheduleMailUtils {
    private static final String CLASS_TAG = "[DWSchedule.DWScheduleMailUtils]";
    private static Log log = LogFactory.getLog(DWScheduleMailUtils.class);

    public static void sendEmail(Object list, String executeState) throws Exception {
        List contactList = (List)list;
        String mailSubject = "";
        String mailContent = "";
        DWScheduleProperties scheduleProperties = DWScheduleProperties.getDefaultProperties();
        if (contactList != null && contactList.size() > 0) {
            ArrayList<String> receiver = new ArrayList<String>();
            ArrayList<String> cc = new ArrayList<String>();
            ArrayList<String> bcc = new ArrayList<String>();
            for (int i = 0; i < contactList.size(); ++i) {
                ScheduleContactDO contact = (ScheduleContactDO)contactList.get(i);
                if (!contact.getSendCondition().equals(executeState)) continue;
                mailSubject = contact.getMailSubject();
                mailContent = contact.getMailContent();
                switch (contact.getMailType()) {
                    case "1": {
                        receiver.add(contact.getReceiverEmail());
                        break;
                    }
                    case "2": {
                        cc.add(contact.getReceiverEmail());
                        break;
                    }
                    case "3": {
                        bcc.add(contact.getReceiverEmail());
                    }
                }
                String receiverList = DWScheduleMailUtils.getMailCsvList(receiver);
                String ccList = DWScheduleMailUtils.getMailCsvList(cc);
                String bccList = DWScheduleMailUtils.getMailCsvList(bcc);
                String sender = scheduleProperties.getEmailSender();
                String smtpHost = scheduleProperties.getEmailSMTPHost();
                int port = scheduleProperties.getEmailSMTPPort();
                String username = scheduleProperties.getEmailUserName();
                String passwd = scheduleProperties.getEmailPassword();
                int typeOfConnection = scheduleProperties.getEmailTransportType();
                DWMailUtils.doSendMail((String)sender, (String)receiverList, (String)ccList, (String)bccList, (String)smtpHost, (int)port, (String)username, (String)passwd, (String)mailSubject, (String)mailContent, (Integer)typeOfConnection);
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] receiver: " + String.join((CharSequence)",", receiver)));
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] cc: " + String.join((CharSequence)",", cc)));
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] bcc: " + String.join((CharSequence)",", bcc)));
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] mailSubject: " + mailSubject));
                log.info((Object)("[DWSchedule.DWScheduleMailUtils] executeState: " + executeState));
            }
        }
    }

    public static String getMailCsvList(List<String> mailReceivers) {
        if (mailReceivers.size() == 0) {
            return "";
        }
        Object list = "";
        for (String receiver : mailReceivers) {
            list = (String)list + receiver + ",";
        }
        if (((String)list).endsWith(",")) {
            list = ((String)list).substring(0, ((String)list).length() - 1);
        }
        return list;
    }
}

