/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.schedule.quartz;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.entity.UpdateBatchPojo;
import com.digiwin.app.schedule.quartz.DWCalendarIntervalScheduleBuilder;
import com.digiwin.app.schedule.quartz.DWSimpleScheduleBuilder;
import com.digiwin.app.schedule.quartz.listener.DWQuartzJobListener;
import com.digiwin.app.schedule.util.DWScheduleExceptionUtils;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.RecurrenceRuleScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.DWStdScheduler;
import org.quartz.impl.DWStdSchedulerFactory;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.utils.DBConnectionManager;
import org.springframework.data.redis.core.RedisTemplate;

public class DWQuartz {
    private static final String CLASS_TAG = "[DWSchedule.DWQuartz]";
    private static final Log log = LogFactory.getLog(DWQuartz.class);
    private static DWStdScheduler scheduler;
    private static DWQuartz instance;
    private static String instanceId;
    public static RedisTemplate redisTemplate;
    private static Properties quartzProperties;
    private static boolean start_init;
    private static boolean standby_init;

    public static DWQuartz getInstance() {
        if (instance == null && SpringContextUtils.containsBean((String)"DWQuartz")) {
            instance = (DWQuartz)SpringContextUtils.getBean((String)"DWQuartz");
        }
        return instance;
    }

    public static void setInstance(DWQuartz instance) {
        DWQuartz.instance = instance;
    }

    public DWQuartz(Properties quartzProperties) throws Exception {
        DWQuartz.quartzProperties = quartzProperties;
    }

    public synchronized void startup() throws Exception {
        DWQuartz.startup(quartzProperties);
    }

    public synchronized void standby() throws Exception {
        DWQuartz.standby(quartzProperties);
    }

    public static void shutdown() throws Exception {
        if (scheduler != null) {
            if (DistributedScheduleUtils.isWorker()) {
                redisTemplate.expire((Object)DistributedScheduleUtils.getWorkerId(), 1L, TimeUnit.SECONDS);
            }
            scheduler.shutdown();
        }
    }

    public static void startup(Properties quartzProperties) throws Exception {
        String instanceId;
        if (start_init) {
            return;
        }
        DWStdSchedulerFactory factory = new DWStdSchedulerFactory(quartzProperties);
        scheduler = (DWStdScheduler)factory.getScheduler();
        scheduler.start();
        scheduler.getListenerManager().addJobListener((JobListener)new DWQuartzJobListener());
        start_init = true;
        DWQuartz.instanceId = instanceId = scheduler.getSchedulerInstanceId();
    }

    public static void standby(Properties quartzProperties) throws Exception {
        String instanceId;
        if (standby_init) {
            String instanceId2;
            DWQuartz.instanceId = instanceId2 = scheduler.getSchedulerInstanceId();
        }
        DWStdSchedulerFactory factory = new DWStdSchedulerFactory(quartzProperties);
        scheduler = (DWStdScheduler)factory.getScheduler();
        scheduler.standby();
        scheduler.getListenerManager().addJobListener((JobListener)new DWQuartzJobListener());
        standby_init = true;
        DWQuartz.instanceId = instanceId = scheduler.getSchedulerInstanceId();
        log.info((Object)"[leaderElectionSchedule] quartz standby");
        log.info((Object)("[leaderElectionSchedule] instanceId: " + instanceId));
    }

    public void addJob(JobDetail jobDetail) throws Exception {
        scheduler.addJob(jobDetail, true, true);
    }

    public void triggerJob(JobKey jobkey) {
        try {
            scheduler.triggerJob(jobkey);
        }
        catch (SchedulerException e) {
            DWScheduleExceptionUtils.log(log, CLASS_TAG, (Exception)((Object)e));
        }
    }

    public void scheduleJob(Trigger trigger, JobDetail jobDetail) throws Exception {
        try {
            scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            if (e.getMessage() != null && e.getMessage().endsWith("' will never fire.")) {
                log.warn((Object)("[DWSchedule.DWQuartz] " + e.getMessage()));
            }
            throw e;
        }
    }

    public void scheduleJob(Set<Trigger> triggers, JobDetail jobDetail) throws Exception {
        scheduler.scheduleJob(jobDetail, triggers, true);
    }

    public void scheduleJobs(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs) throws Exception {
        scheduler.scheduleJobs(triggersAndJobs, true);
    }

    public void deleteBeforeStoreJobsAndTriggers(List<UpdateBatchPojo> updateBatchPojos) throws Exception {
        scheduler.deleteBeforeStoreJobsAndTriggers(updateBatchPojos, true);
    }

    public void unScheduleJob(String jobName, String groupName) throws Exception {
        JobKey key = new JobKey(jobName, groupName);
        List triggers = scheduler.getTriggersOfJob(key);
        if (triggers.size() > 0) {
            for (int i = 0; i < triggers.size(); ++i) {
                scheduler.unscheduleJob(((Trigger)triggers.get(i)).getKey());
            }
        }
    }

    public boolean deleteJob(String groupName) {
        boolean result = false;
        try {
            Set jobKeys = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            if (jobKeys != null && jobKeys.size() > 0) {
                for (JobKey jobKey : jobKeys) {
                    if (scheduler.deleteJob(jobKey)) {
                        result = true;
                        continue;
                    }
                    result = false;
                }
            } else {
                result = true;
            }
        }
        catch (SchedulerException e) {
            DWScheduleExceptionUtils.log(log, CLASS_TAG, (Exception)((Object)e));
        }
        return result;
    }

    public boolean deleteJob(JobKey jobKey) {
        try {
            return scheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            DWScheduleExceptionUtils.log(log, CLASS_TAG, (Exception)((Object)e));
            return false;
        }
    }

    public static Trigger createTrigger(String triggerName, String groupName, String cronExpression, int misfirePolicy, JobDataMap jobData) {
        return switch (misfirePolicy) {
            case -1 -> TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionIgnoreMisfires()).usingJobData(jobData).build();
            case 2 -> TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionDoNothing()).usingJobData(jobData).build();
            case 1 -> TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionFireAndProceed()).usingJobData(jobData).build();
            case 0 -> TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).usingJobData(jobData).build();
            default -> TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).usingJobData(jobData).build();
        };
    }

    public JobDetail createJobDetail(String jobName, String groupName, JobDataMap jobDataMap, Class<? extends Job> jobClass) throws ClassNotFoundException {
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, groupName).setJobData(jobDataMap).build();
        return jobDetail;
    }

    public static Trigger createCalendarTrigger(String triggerName, String groupName, int timeInterval, DateBuilder.IntervalUnit unit, Date startTime, Date endTime, JobDataMap jobData) {
        Trigger trigger = null;
        DWCalendarIntervalScheduleBuilder cb = new DWCalendarIntervalScheduleBuilder();
        cb.withInterval(timeInterval, unit);
        trigger = endTime != null ? TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)cb).startAt(startTime).endAt(endTime).usingJobData(jobData).build() : TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)cb).startAt(startTime).usingJobData(jobData).build();
        return trigger;
    }

    public static Trigger createSimpleTrigger(String triggerName, String groupName, int timeInterval, DateBuilder.IntervalUnit unit, Date startTime, Date endTime, Integer repeat, JobDataMap jobData) {
        Trigger trigger = null;
        DWSimpleScheduleBuilder ssb = new DWSimpleScheduleBuilder();
        switch (unit) {
            case MINUTE: {
                ssb.withIntervalInMinutes(timeInterval);
                break;
            }
            case HOUR: {
                ssb.withIntervalInHours(timeInterval);
                break;
            }
            case DAY: {
                ssb.withIntervalInHours(24 * timeInterval);
                break;
            }
        }
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)ssb.withRepeatCount(repeat)).startAt(startTime).usingJobData(jobData);
        if (endTime != null) {
            builder.endAt(endTime);
        }
        trigger = builder.build();
        return trigger;
    }

    public static Trigger createRecurrenceRuleTrigger(String triggerName, String groupName, String rrule, Date startTime, Date endTime, JobDataMap jobData) {
        RecurrenceRuleScheduleBuilder builder = RecurrenceRuleScheduleBuilder.recurrenceRuleSchedule(rrule);
        return TriggerBuilder.newTrigger().withIdentity(triggerName, groupName).withSchedule((ScheduleBuilder)builder).startAt(startTime).endAt(endTime).usingJobData(jobData).build();
    }

    public static String getSchedulerName() throws SchedulerException {
        return scheduler.getSchedulerName() == null ? "" : scheduler.getSchedulerName();
    }

    public boolean updateJobData(JobKey jobkey, Map<String, Object> newJobDataMap) throws Exception {
        JobDetailImpl jobDetail = (JobDetailImpl)scheduler.getJobDetail(jobkey);
        if (jobDetail != null) {
            jobDetail.setDurability(true);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            for (Map.Entry<String, Object> newJobData : newJobDataMap.entrySet()) {
                jobDataMap.put(newJobData.getKey().toString(), newJobData.getValue());
            }
            scheduler.addJob((JobDetail)jobDetail, true);
        }
        return true;
    }

    public static void electLeader() throws Exception {
        String instanceName = quartzProperties.getProperty("org.quartz.scheduler.instanceName");
        String dataSourceName = quartzProperties.getProperty("org.quartz.jobStore.dataSource");
        String tablePrefix = quartzProperties.getProperty("org.quartz.jobStore.tablePrefix");
        String insertLockSql = String.format("INSERT INTO %sLOCKS (SCHED_NAME, LOCK_NAME)\nSELECT * FROM (SELECT ?, 'LEADER_ELECTION') AS TEMP\nWHERE NOT EXISTS (\n  SELECT 1\n  FROM %sLOCKS\n  WHERE SCHED_NAME = ? AND LOCK_NAME = 'LEADER_ELECTION'\n);\n", tablePrefix, tablePrefix);
        Connection insertLockConnection = DBConnectionManager.getInstance().getConnection(dataSourceName);
        try (PreparedStatement insertLockPreparedStatement = insertLockConnection.prepareStatement(insertLockSql);){
            insertLockPreparedStatement.setString(1, instanceName);
            insertLockPreparedStatement.setString(2, instanceName);
            ResultSet insertLockResultSet = insertLockPreparedStatement.executeQuery();
            if (insertLockResultSet != null) {
                insertLockResultSet.close();
            }
        }
        catch (Throwable e) {
            log.error((Object)("[leaderElectionSchedule] error message: " + e.getMessage()), e);
            throw e;
        }
        finally {
            try {
                if (insertLockConnection != null) {
                    insertLockConnection.close();
                }
            }
            catch (Throwable e) {
                log.error((Object)("[leaderElectionSchedule] error message: " + e.getMessage()), e);
                throw e;
            }
        }
        Connection connection = DBConnectionManager.getInstance().getConnection(dataSourceName);
        String lockSql = String.format("SELECT SCHED_NAME, LOCK_NAME\nFROM %sLOCKS\nWHERE SCHED_NAME = ? AND LOCK_NAME = 'LEADER_ELECTION'\nFOR UPDATE;\n", tablePrefix);
        connection.setAutoCommit(false);
        log.debug((Object)"[leaderElectionSchedule] start SELECT FOR UPDATE");
        boolean start = false;
        try (PreparedStatement lockPreparedStatement = connection.prepareStatement(lockSql);){
            block108: {
                lockPreparedStatement.setString(1, instanceName);
                ResultSet lockResultSet = lockPreparedStatement.executeQuery();
                if (lockResultSet != null) {
                    lockResultSet.close();
                }
                String currentLeader = null;
                String selectLeaderSql = String.format("SELECT LOCK_NAME\nFROM %sLOCKS\nWHERE SCHED_NAME = ? AND LOCK_NAME != 'STATE_ACCESS'\nAND LOCK_NAME != 'TRIGGER_ACCESS' AND LOCK_NAME != 'LEADER_ELECTION';\n", tablePrefix);
                try (PreparedStatement selectLeaderPreparedStatement = connection.prepareStatement(selectLeaderSql);){
                    selectLeaderPreparedStatement.setString(1, instanceName);
                    try (ResultSet selectLeaderResultSet = selectLeaderPreparedStatement.executeQuery();){
                        while (selectLeaderResultSet.next()) {
                            currentLeader = selectLeaderResultSet.getString("LOCK_NAME");
                        }
                        if (currentLeader == null) {
                            log.debug((Object)"[leaderElectionSchedule] no currentLeader");
                            String insertLeaderSql = String.format("INSERT INTO %sLOCKS (SCHED_NAME, LOCK_NAME) VALUES (?, ?);\n", tablePrefix);
                            try (PreparedStatement insertLeaderPreparedStatement = connection.prepareStatement(insertLeaderSql);){
                                insertLeaderPreparedStatement.setString(1, instanceName);
                                insertLeaderPreparedStatement.setString(2, instanceId);
                                ResultSet insertLeaderResultSet = insertLeaderPreparedStatement.executeQuery();
                                if (insertLeaderResultSet != null) {
                                    insertLeaderResultSet.close();
                                }
                            }
                            start = true;
                            log.info((Object)("[leaderElectionSchedule] new currentLeader: " + instanceId));
                            break block108;
                        }
                        log.debug((Object)("[leaderElectionSchedule] currentLeader: " + currentLeader));
                        if (currentLeader.equals(instanceId)) {
                            start = true;
                            break block108;
                        }
                        String selectCurrentLeaderLastCheckinTimeSql = String.format("SELECT LAST_CHECKIN_TIME\nFROM %sSCHEDULER_STATE\nWHERE SCHED_NAME = ? AND INSTANCE_NAME = ?;\n", tablePrefix);
                        try (PreparedStatement selectCurrentLeaderLastCheckinTimePreparedStatement = connection.prepareStatement(selectCurrentLeaderLastCheckinTimeSql);){
                            selectCurrentLeaderLastCheckinTimePreparedStatement.setString(1, instanceName);
                            selectCurrentLeaderLastCheckinTimePreparedStatement.setString(2, currentLeader);
                            try (ResultSet selectCurrentLeaderLastCheckinTimeResultSet = selectCurrentLeaderLastCheckinTimePreparedStatement.executeQuery();){
                                Long leaderLastCheckinTime = null;
                                while (selectCurrentLeaderLastCheckinTimeResultSet.next()) {
                                    leaderLastCheckinTime = selectCurrentLeaderLastCheckinTimeResultSet.getLong("LAST_CHECKIN_TIME");
                                }
                                long clusterCheckinInterval = Long.valueOf(quartzProperties.getProperty("org.quartz.jobStore.clusterCheckinInterval", "20000"));
                                long heartbeat = clusterCheckinInterval + clusterCheckinInterval / 2L;
                                long now = System.currentTimeMillis();
                                log.debug((Object)("[leaderElectionSchedule] clusterCheckinInterval: " + clusterCheckinInterval + ", heartbeat: " + heartbeat + ", now: " + now + ", leaderLastCheckinTime: " + leaderLastCheckinTime + ", now - leaderLastCheckinTime: " + (now - leaderLastCheckinTime)));
                                if (leaderLastCheckinTime != null && now - leaderLastCheckinTime < heartbeat) break block108;
                                String deleteLeaderSql = String.format("\t\tDELETE FROM %sLOCKS\nWHERE SCHED_NAME = ? AND LOCK_NAME != 'STATE_ACCESS'\nAND LOCK_NAME != 'TRIGGER_ACCESS' AND LOCK_NAME != 'LEADER_ELECTION';\n", tablePrefix);
                                try (PreparedStatement deleteLeaderPreparedStatement = connection.prepareStatement(deleteLeaderSql);){
                                    deleteLeaderPreparedStatement.setString(1, instanceName);
                                    ResultSet deleteLeaderResultSet = deleteLeaderPreparedStatement.executeQuery();
                                    if (deleteLeaderResultSet != null) {
                                        deleteLeaderResultSet.close();
                                    }
                                }
                                String insertLeaderSql = String.format("INSERT INTO %sLOCKS (SCHED_NAME, LOCK_NAME) VALUES (?, ?);\n", tablePrefix);
                                try (PreparedStatement insertLeaderPreparedStatement = connection.prepareStatement(insertLeaderSql);){
                                    insertLeaderPreparedStatement.setString(1, instanceName);
                                    insertLeaderPreparedStatement.setString(2, instanceId);
                                    ResultSet insertLeaderResultSet = insertLeaderPreparedStatement.executeQuery();
                                    if (insertLeaderResultSet != null) {
                                        insertLeaderResultSet.close();
                                    }
                                }
                                start = true;
                                log.info((Object)("[leaderElectionSchedule] new currentLeader: " + instanceId));
                            }
                        }
                    }
                }
            }
            connection.commit();
            log.debug((Object)"[leaderElectionSchedule] end SELECT FOR UPDATE");
        }
        catch (Throwable e) {
            connection.rollback();
            log.error((Object)("[leaderElectionSchedule] error message: " + e.getMessage()), e);
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable e) {
                log.error((Object)("[leaderElectionSchedule] error message: " + e.getMessage()), e);
                throw e;
            }
        }
        if (start) {
            if (start_init) {
                return;
            }
            Connection insertSchedulerStateConnection = DBConnectionManager.getInstance().getConnection(dataSourceName);
            String insertSchedulerStateSql = String.format("INSERT INTO %sSCHEDULER_STATE (SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL)\nVALUES (?, ?, ?, ?);\n", tablePrefix);
            try (PreparedStatement insertSchedulerStateStatement = insertSchedulerStateConnection.prepareStatement(insertSchedulerStateSql);){
                insertSchedulerStateStatement.setString(1, instanceName);
                insertSchedulerStateStatement.setString(2, instanceId);
                long now = System.currentTimeMillis();
                long clusterCheckinInterval = Long.valueOf(quartzProperties.getProperty("org.quartz.jobStore.clusterCheckinInterval", "20000"));
                insertSchedulerStateStatement.setLong(3, now);
                insertSchedulerStateStatement.setLong(4, clusterCheckinInterval);
                ResultSet insertSchedulerStateResultSet = insertSchedulerStateStatement.executeQuery();
                if (insertSchedulerStateResultSet != null) {
                    insertSchedulerStateResultSet.close();
                }
            }
            catch (Throwable e) {
                log.error((Object)("[leaderElectionSchedule] error message: " + e.getMessage()), e);
                throw e;
            }
            instance.startup();
            log.info((Object)"[leaderElectionSchedule] quartz start");
        }
    }

    public static boolean isLeaderElectionScheduleEnabled() {
        String leaderElectionScheduleEnabled = String.valueOf(quartzProperties.getProperty("leaderElectionScheduleEnabled", "false"));
        return "true".equalsIgnoreCase(leaderElectionScheduleEnabled);
    }

    static {
        instance = null;
        instanceId = null;
        redisTemplate = null;
        start_init = false;
        standby_init = false;
    }
}

