/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWDaoAutoConfiguration;
import com.digiwin.app.autoconfigure.DWScheduleAutoConfiguration;
import com.digiwin.app.autoconfigure.condition.MultiScheduleModeCondition;
import com.digiwin.app.dao.security.AESUtil;
import com.digiwin.app.schedule.DWQuartzProperties;
import com.digiwin.app.schedule.QuartzProperties;
import com.digiwin.app.schedule.context.DWScheduleContext;
import com.digiwin.app.schedule.dbservice.DWScheduleContactDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleRecordDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleTimeDBService;
import com.digiwin.app.schedule.quartz.SingleQuartz;
import com.digiwin.app.schedule.quartz.multi.DWMultiQuartz;
import com.digiwin.app.schedule.quartz.multi.MultiQuartz;
import com.digiwin.app.schedule.service.DWJobService;
import com.digiwin.app.schedule.service.DWScheduleService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Configuration
@DependsOn(value={"scheduleConfigProvider", "scheduleRequestContextProvider", "scheduleServiceProvider", "scheduleThrowDWExceptionProvider", "dw-spring-context-utils", "dw-json-config"})
@AutoConfigureBefore(value={DWDaoAutoConfiguration.class})
@Conditional(value={MultiScheduleModeCondition.class})
public class MultiScheduleModeAutoConfiguration {
    private static final String KEY_FALSE = "false";
    private List<SingleQuartz> singleQuartzList = new ArrayList<SingleQuartz>();
    private static Log log = LogFactory.getLog(MultiScheduleModeAutoConfiguration.class);

    @Bean(name={"DWMultiQuartz"})
    @DependsOn(value={"dw-rdbMetadataLoader", "dw-schedule-properties"})
    @Conditional(value={MultiScheduleModeCondition.class})
    public MultiQuartz multiQuartz(ConfigurableEnvironment environment, @Qualifier(value="dap-application-propertysource") PropertySource dapApplicationPropertySource) throws Exception {
        DWMultiQuartz multiQuartz = new DWMultiQuartz();
        String multiDataSources = environment.getProperty("org.quartz.jobStore.multiDataSources", "");
        List<String> multiDataSourceList = Arrays.asList(multiDataSources.trim().split(","));
        for (String dataSource : multiDataSourceList) {
            Properties fixedValueProperties = new Properties();
            fixedValueProperties.setProperty("org.quartz.jobStore.misfireThreshold", environment.getProperty("org.quartz.jobStore.misfireThreshold", "60000"));
            fixedValueProperties.setProperty("org.quartz.dataSource." + dataSource + ".driver", environment.getProperty("jdbcDriverClassName", ""));
            String urlNamespace = "org.quartz.dataSource." + dataSource + ".URL";
            String userNamespace = "org.quartz.dataSource." + dataSource + ".user";
            fixedValueProperties.setProperty(urlNamespace, environment.getProperty(urlNamespace, ""));
            fixedValueProperties.setProperty(userNamespace, environment.getProperty(userNamespace, ""));
            String passwordNamespace = "org.quartz.dataSource." + dataSource + ".password";
            String dbPasswordEncryptionKey = environment.getProperty("dbPasswordEncryptionKey", "");
            String dbPassword = environment.getProperty(passwordNamespace, "");
            if (dbPasswordEncryptionKey != null && !"".equals(dbPasswordEncryptionKey.trim())) {
                dbPassword = AESUtil.decode((String)dbPassword, (String)dbPasswordEncryptionKey);
            }
            fixedValueProperties.setProperty(passwordNamespace, dbPassword);
            DWQuartzProperties.buildDWQuartzProperties((Properties)fixedValueProperties);
            MutablePropertySources propSrcs = environment.getPropertySources();
            boolean isDefaultDataSourceName = dataSource.equals(environment.getProperty("org.quartz.jobStore.dataSource"));
            Set keys = StreamSupport.stream(propSrcs.spliterator(), false).filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream).filter(name -> {
                String dataSourcePrefix = "org.quartz.dataSource." + dataSource;
                if (name.startsWith(dataSourcePrefix)) {
                    return true;
                }
                for (String excludeDataSource : multiDataSourceList) {
                    String excludeDataSourcePrefix;
                    if (dataSource.equals(excludeDataSource) || !name.startsWith(excludeDataSourcePrefix = "org.quartz.dataSource." + excludeDataSource)) continue;
                    return false;
                }
                return isDefaultDataSourceName || name != null && !name.startsWith("org.quartz.dataSource.quartzDataSource.");
            }).collect(Collectors.toSet());
            keys.addAll(fixedValueProperties.keySet().stream().map(k -> k.toString()).collect(Collectors.toSet()));
            keys.remove("org.quartz.jobStore.multiDataSources");
            Function<String, String> get = key -> {
                String propertyValue = environment.getProperty(key);
                if ("org.quartz.jobStore.dataSource".equals(key)) {
                    return dataSource;
                }
                if ("org.quartz.scheduler.instanceName".equals(key)) {
                    return propertyValue == null ? fixedValueProperties.getProperty((String)key) + "_" + dataSource : propertyValue + "_" + dataSource;
                }
                String leaderElectionScheduleEnabled = String.valueOf(environment.getProperty("leaderElectionScheduleEnabled", KEY_FALSE));
                if ("true".equalsIgnoreCase(leaderElectionScheduleEnabled) && "org.quartz.jobStore.lockHandler.class".equals(key)) {
                    log.info((Object)"[leaderElectionSchedule] org.quartz.jobStore.lockHandler.class=org.quartz.impl.jdbcjobstore.NoLockSemaphore");
                    return "org.quartz.impl.jdbcjobstore.NoLockSemaphore";
                }
                return propertyValue == null ? fixedValueProperties.getProperty((String)key) : propertyValue;
            };
            BiFunction<String, String, String> getOrDefault = (key, defaultValue) -> {
                String propertyValue = environment.getProperty(key);
                if ("org.quartz.jobStore.dataSource".equals(key)) {
                    return dataSource;
                }
                if ("org.quartz.scheduler.instanceName".equals(key)) {
                    return propertyValue == null ? fixedValueProperties.getProperty((String)key) + "_" + dataSource : propertyValue + "_" + dataSource;
                }
                String leaderElectionScheduleEnabled = String.valueOf(environment.getProperty("leaderElectionScheduleEnabled", KEY_FALSE));
                if ("true".equalsIgnoreCase(leaderElectionScheduleEnabled) && "org.quartz.jobStore.lockHandler.class".equals(key)) {
                    log.info((Object)"[leaderElectionSchedule] org.quartz.jobStore.lockHandler.class=org.quartz.impl.jdbcjobstore.NoLockSemaphore");
                    return "org.quartz.impl.jdbcjobstore.NoLockSemaphore";
                }
                return propertyValue == null ? fixedValueProperties.getProperty((String)key) : propertyValue;
            };
            QuartzProperties properties = new QuartzProperties(get, getOrDefault, keys);
            multiQuartz.add(dataSource, (Properties)properties);
        }
        if (!Boolean.TRUE.equals(Boolean.parseBoolean(environment.getProperty("dap.schedule.start-up-after-app-started")))) {
            multiQuartz.startupElements();
        }
        Map elements = multiQuartz.getAll();
        this.singleQuartzList.addAll(elements.values());
        return multiQuartz;
    }

    @Bean(name={"DWScheduleContext"})
    @DependsOn(value={"dw-fuse-default-option"})
    @Conditional(value={MultiScheduleModeCondition.class})
    public DWScheduleContext multiScheduleContext(ConfigurableEnvironment environment, @Qualifier(value="DWScheduleDBService") DWScheduleDBService scheduleDBService, @Qualifier(value="DWScheduleTimeDBService") DWScheduleTimeDBService scheduleTimeDBService, @Qualifier(value="DWScheduleRecordDBService") DWScheduleRecordDBService scheduleRecordDBService, @Qualifier(value="DWScheduleContactDBService") DWScheduleContactDBService scheduleContactDBService, MultiQuartz multiQuartz) {
        String isScheduleJsonOutputString = environment.getProperty("isScheduleJsonOutput", KEY_FALSE);
        boolean isScheduleJsonOutput = false;
        if ("true".equalsIgnoreCase(isScheduleJsonOutputString)) {
            isScheduleJsonOutput = true;
        }
        boolean finalIsScheduleJsonOutput = isScheduleJsonOutput;
        DWScheduleContext scheduleContext = new DWScheduleContext();
        Map elements = multiQuartz.getAll();
        elements.forEach((key, value) -> {
            DWJobService jobService = new DWJobService(value);
            DWScheduleService scheduleService = new DWScheduleService(value, jobService);
            DWScheduleContext dataSourceScheduleContext = new DWScheduleContext(scheduleDBService, scheduleTimeDBService, scheduleRecordDBService, scheduleContactDBService, scheduleService, jobService);
            dataSourceScheduleContext.setScheduleJsonOutput(finalIsScheduleJsonOutput);
            DWScheduleContext.setInstance((String)key, (DWScheduleContext)dataSourceScheduleContext);
        });
        return scheduleContext;
    }

    @PreDestroy
    public void onDestroy() throws Exception {
        LogFactory.getLog(DWScheduleAutoConfiguration.class).info((Object)"DWQuartz shutting down.");
        for (SingleQuartz quartzList : this.singleQuartzList) {
            quartzList.shutdown();
        }
        LogFactory.getLog(DWScheduleAutoConfiguration.class).info((Object)"DWQuartz shutdown complete.");
    }
}

