/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWScheduleAutoConfiguration;
import com.digiwin.app.autoconfigure.condition.DWLeaderElectionScheduleCondition;
import com.digiwin.app.autoconfigure.condition.SingleScheduleModeCondition;
import com.digiwin.app.dao.security.AESUtil;
import com.digiwin.app.schedule.DWQuartzProperties;
import com.digiwin.app.schedule.QuartzProperties;
import com.digiwin.app.schedule.context.DWScheduleContext;
import com.digiwin.app.schedule.dbservice.DWScheduleContactDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleRecordDBService;
import com.digiwin.app.schedule.dbservice.DWScheduleTimeDBService;
import com.digiwin.app.schedule.leaderelection.LeaderElectionQuartz;
import com.digiwin.app.schedule.leaderelection.LeaderElectionScheduler;
import com.digiwin.app.schedule.quartz.DWQuartz;
import com.digiwin.app.schedule.quartz.SingleQuartz;
import com.digiwin.app.schedule.service.DWJobService;
import com.digiwin.app.schedule.service.DWScheduleService;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Configuration
@DependsOn(value={"scheduleConfigProvider", "scheduleRequestContextProvider", "scheduleServiceProvider", "scheduleThrowDWExceptionProvider", "dw-spring-context-utils", "dw-json-config"})
@AutoConfigureBefore(value={SingleScheduleModeCondition.class})
@Conditional(value={SingleScheduleModeCondition.class})
public class SingleScheduleModeAutoConfiguration {
    private static final String KEY_FALSE = "false";
    private List<SingleQuartz> singleQuartzList = new ArrayList<SingleQuartz>();
    private static Log log = LogFactory.getLog(SingleScheduleModeAutoConfiguration.class);

    @Bean
    @Conditional(value={DWLeaderElectionScheduleCondition.class})
    public LeaderElectionScheduler leaderElectionScheduler(ConfigurableEnvironment environment, LeaderElectionQuartz leaderElectionQuartz) {
        long clusterCheckinInterval = Long.valueOf(environment.getProperty("org.quartz.jobStore.clusterCheckinInterval", "20000"));
        long heartbeat = clusterCheckinInterval + clusterCheckinInterval / 2L;
        return new LeaderElectionScheduler(heartbeat, leaderElectionQuartz);
    }

    @Bean(name={"DWQuartz"})
    @DependsOn(value={"dw-rdbMetadataLoader", "dw-schedule-properties"})
    public LeaderElectionQuartz quartz(ConfigurableEnvironment environment, @Qualifier(value="dap-application-propertysource") PropertySource dapApplicationPropertySource) throws Exception {
        Properties fixedValueProperties = new Properties();
        fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.driver", environment.getProperty("jdbcDriverClassName", ""));
        String dbUrl = environment.getProperty("dbUrl");
        if (StringUtils.isBlank((CharSequence)dbUrl)) {
            String dbUrlType = environment.getProperty("dbUrlType");
            String dbUrlHost = environment.getProperty("dbUrlHost");
            String dbUrlPort = environment.getProperty("dbUrlPort");
            String dbUrlDatabase = environment.getProperty("dbUrlDatabase");
            String dbUrlArgs = environment.getProperty("dbUrlArgs");
            StringBuilder dbUrlCombination = new StringBuilder();
            dbUrlCombination.append("jdbc:" + dbUrlType + "://" + dbUrlHost);
            if (!"".equals(dbUrlPort)) {
                dbUrlCombination.append(":" + dbUrlPort);
            }
            dbUrlCombination.append("/" + dbUrlDatabase);
            if (!"".equals(dbUrlArgs)) {
                dbUrlCombination.append("?" + dbUrlArgs);
            }
            dbUrl = dbUrlCombination.toString();
        }
        fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.URL", dbUrl);
        fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.user", environment.getProperty("dbUsername", ""));
        String dbPasswordEncryptionKey = environment.getProperty("dbPasswordEncryptionKey", "");
        String dbPassword = environment.getProperty("dbPassword", "");
        if (dbPasswordEncryptionKey != null && !"".equals(dbPasswordEncryptionKey.trim())) {
            dbPassword = AESUtil.decode((String)dbPassword, (String)dbPasswordEncryptionKey);
        }
        fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.password", dbPassword);
        fixedValueProperties.setProperty("org.quartz.jobStore.misfireThreshold", environment.getProperty("org.quartz.jobStore.misfireThreshold", "60000"));
        if (DistributedScheduleUtils.isWorker()) {
            fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.URL", DistributedScheduleUtils.workerProperties.getDbUrl());
            fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.user", DistributedScheduleUtils.workerProperties.getDbUserName());
            fixedValueProperties.setProperty("org.quartz.dataSource.quartzDataSource.password", DistributedScheduleUtils.workerProperties.getDbPassword());
        }
        DWQuartzProperties.buildDWQuartzProperties((Properties)fixedValueProperties);
        MutablePropertySources propSrcs = environment.getPropertySources();
        boolean isDefaultDataSourceName = "quartzDataSource".equals(environment.getProperty("org.quartz.jobStore.dataSource"));
        Set keys = StreamSupport.stream(propSrcs.spliterator(), false).filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream).filter(name -> isDefaultDataSourceName || name != null && !name.startsWith("org.quartz.dataSource.quartzDataSource.")).collect(Collectors.toSet());
        keys.addAll(fixedValueProperties.keySet().stream().map(k -> k.toString()).collect(Collectors.toSet()));
        Function<String, String> get = key -> {
            String propertyValue = environment.getProperty(key);
            String leaderElectionScheduleEnabled = String.valueOf(environment.getProperty("leaderElectionScheduleEnabled", KEY_FALSE));
            if ("true".equalsIgnoreCase(leaderElectionScheduleEnabled) && "org.quartz.jobStore.lockHandler.class".equals(key)) {
                log.info((Object)"[leaderElectionSchedule] org.quartz.jobStore.lockHandler.class=org.quartz.impl.jdbcjobstore.NoLockSemaphore");
                return "org.quartz.impl.jdbcjobstore.NoLockSemaphore";
            }
            return propertyValue == null ? fixedValueProperties.getProperty((String)key) : propertyValue;
        };
        BiFunction<String, String, String> getOrDefault = (key, defaultValue) -> {
            String propertyValue = environment.getProperty(key);
            String leaderElectionScheduleEnabled = String.valueOf(environment.getProperty("leaderElectionScheduleEnabled", KEY_FALSE));
            if ("true".equalsIgnoreCase(leaderElectionScheduleEnabled) && "org.quartz.jobStore.lockHandler.class".equals(key)) {
                log.info((Object)"[leaderElectionSchedule] org.quartz.jobStore.lockHandler.class=org.quartz.impl.jdbcjobstore.NoLockSemaphore");
                return "org.quartz.impl.jdbcjobstore.NoLockSemaphore";
            }
            return propertyValue == null ? fixedValueProperties.getProperty((String)key) : propertyValue;
        };
        QuartzProperties properties = new QuartzProperties(get, getOrDefault, keys);
        DWQuartz quartz = new DWQuartz((Properties)properties);
        if (!Boolean.TRUE.equals(Boolean.parseBoolean(environment.getProperty("dap.schedule.start-up-after-app-started")))) {
            boolean leaderElectionScheduleEnabled = quartz.isLeaderElectionScheduleEnabled();
            if (leaderElectionScheduleEnabled) {
                log.info((Object)"[leaderElectionSchedule] leaderElectionScheduleEnabled: true");
                quartz.standby();
                quartz.electLeader();
            } else {
                quartz.startup();
            }
        }
        DWQuartz.setInstance((DWQuartz)quartz);
        this.singleQuartzList.add((SingleQuartz)quartz);
        return quartz;
    }

    @Bean(name={"DWScheduleContext"})
    @DependsOn(value={"dw-fuse-default-option"})
    public DWScheduleContext scheduleContext(ConfigurableEnvironment environment, @Qualifier(value="DWScheduleDBService") DWScheduleDBService scheduleDBService, @Qualifier(value="DWScheduleTimeDBService") DWScheduleTimeDBService scheduleTimeDBService, @Qualifier(value="DWScheduleRecordDBService") DWScheduleRecordDBService scheduleRecordDBService, @Qualifier(value="DWScheduleContactDBService") DWScheduleContactDBService scheduleContactDBService, SingleQuartz quartz) {
        String isScheduleJsonOutputString = environment.getProperty("isScheduleJsonOutput", KEY_FALSE);
        boolean isScheduleJsonOutput = false;
        if ("true".equalsIgnoreCase(isScheduleJsonOutputString)) {
            isScheduleJsonOutput = true;
        }
        DWJobService jobService = new DWJobService(quartz);
        DWScheduleService scheduleService = new DWScheduleService(quartz, jobService);
        DWScheduleContext scheduleContext = new DWScheduleContext(scheduleDBService, scheduleTimeDBService, scheduleRecordDBService, scheduleContactDBService, scheduleService, jobService);
        DWScheduleContext.setInstance((DWScheduleContext)scheduleContext);
        scheduleContext.setScheduleJsonOutput(isScheduleJsonOutput);
        return scheduleContext;
    }

    @PreDestroy
    public void onDestroy() throws Exception {
        LogFactory.getLog(DWScheduleAutoConfiguration.class).info((Object)"DWQuartz shutting down.");
        for (SingleQuartz quartzList : this.singleQuartzList) {
            quartzList.shutdown();
        }
        LogFactory.getLog(DWScheduleAutoConfiguration.class).info((Object)"DWQuartz shutdown complete.");
    }
}

