/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.config;

import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.RequestOriginParser;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.digiwin.sentinel.DWSentinelProperties;
import com.digiwin.sentinel.adapter.springwebmvc.callback.AbstractDWRequestOriginParser;
import com.digiwin.sentinel.adapter.springwebmvc.callback.DWBlockExceptionHandler;
import com.digiwin.sentinel.adapter.springwebmvc.callback.DefaultDWRequestOriginParser;
import com.digiwin.sentinel.adapter.springwebmvc.callback.param.AbstractDWFlowControlParamProvider;
import com.digiwin.sentinel.adapter.springwebmvc.callback.param.DWFlowControlParamProvider;
import com.digiwin.sentinel.adapter.springwebmvc.callback.param.DefaultDWFlowControlParamProvider;
import com.digiwin.sentinel.adapter.springwebmvc.config.DWSentinelWebMvcConfig;
import com.digiwin.sentinel.adapter.springwebmvc.interceptor.DWDapSentinelWebInterceptor;
import com.digiwin.sentinel.adapter.springwebmvc.interceptor.DWSentinelWebInterceptor;
import com.digiwin.sentinel.adapter.springwebmvc.spi.DWSentinelSpiLoader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(name={"dap.sentinel.enable"}, havingValue="true")
@EnableConfigurationProperties(value={DWSentinelProperties.class})
public class DWSentinelInterceptorConfig
implements WebMvcConfigurer {
    private static final Log log = LogFactory.getLog(DWSentinelInterceptorConfig.class);
    private final DWSentinelSpiLoader sentinelSpiLoader;
    @Autowired
    private DWSentinelProperties properties;

    public DWSentinelInterceptorConfig(ApplicationContext context) {
        this.sentinelSpiLoader = new DWSentinelSpiLoader(context);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        this.addSpringMvcInterceptor(registry);
    }

    private void addSpringMvcInterceptor(InterceptorRegistry registry) {
        String originKey;
        DWSentinelWebMvcConfig config = new DWSentinelWebMvcConfig();
        String paramKeys = this.properties.getParamKeys();
        if (StringUtil.isNotBlank((String)paramKeys)) {
            String[] array = paramKeys.split(",");
            List<String> keys = Arrays.asList(array);
            AbstractDWFlowControlParamProvider paramProvider = (AbstractDWFlowControlParamProvider)this.sentinelSpiLoader.loadOrDefault(AbstractDWFlowControlParamProvider.class, (Object)new DefaultDWFlowControlParamProvider());
            paramProvider.setKeys(keys);
            config.setParamKeys(keys);
            config.setParamProvider((DWFlowControlParamProvider)paramProvider);
        }
        if (StringUtil.isNotBlank((String)(originKey = this.properties.getOriginKey()))) {
            AbstractDWRequestOriginParser originParser = (AbstractDWRequestOriginParser)this.sentinelSpiLoader.loadOrDefault(AbstractDWRequestOriginParser.class, (Object)new DefaultDWRequestOriginParser());
            originParser.setKey(originKey);
            config.setOriginParser((RequestOriginParser)originParser);
        }
        config.setBlockExceptionHandler((BlockExceptionHandler)new DWBlockExceptionHandler());
        config.setWebContextUnify(true);
        registry.addInterceptor((HandlerInterceptor)this.creatDWSentinelWebInterceptor(config)).addPathPatterns(new String[]{"/**"});
    }

    private DWSentinelWebInterceptor creatDWSentinelWebInterceptor(DWSentinelWebMvcConfig config) {
        DWDapSentinelWebInterceptor sentinelWebInterceptor = null;
        try {
            Class.forName("com.digiwin.app.service.DWService");
            sentinelWebInterceptor = new DWDapSentinelWebInterceptor(config);
        }
        catch (Exception e) {
            log.warn((Object)"create sentinel interceptor object DWService not exist", (Throwable)e);
            sentinelWebInterceptor = new DWSentinelWebInterceptor(config);
        }
        if (sentinelWebInterceptor == null) {
            new DWSentinelWebInterceptor(config);
        }
        return sentinelWebInterceptor;
    }
}

