/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.interceptor;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.sentinel.adapter.springwebmvc.config.DWSentinelWebMvcConfig;
import com.digiwin.sentinel.adapter.springwebmvc.interceptor.DWSentinelWebInterceptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class DWDapSentinelWebInterceptor
extends DWSentinelWebInterceptor {
    private final DWSentinelWebMvcConfig config;

    public DWDapSentinelWebInterceptor() {
        this(new DWSentinelWebMvcConfig());
    }

    public DWDapSentinelWebInterceptor(DWSentinelWebMvcConfig config) {
        super(config);
        this.config = config == null ? new DWSentinelWebMvcConfig() : config;
    }

    @Override
    protected String getResourceName(HttpServletRequest request) {
        String orgResourceName = null;
        String requestURI = request.getRequestURI();
        if (StringUtil.isNotBlank((String)requestURI) && requestURI.endsWith("/eai")) {
            String digiService = request.getHeader("digi-service");
            JSONObject digiServiceObj = JSON.parseObject((String)digiService);
            orgResourceName = digiServiceObj.getString("name");
        } else {
            DWTargetAPI targetAPI = (DWTargetAPI)request.getAttribute("targetAPI");
            if (targetAPI != null) {
                String moduleName = targetAPI.getHeader().getModuleName();
                DWMethod dwMethod = targetAPI.getMethod();
                DWRequestMapping dwRequestMapping = dwMethod.getMethod().getAnnotation(DWRequestMapping.class);
                if (dwRequestMapping != null) {
                    String requestMethodName = dwRequestMapping.method()[0].name();
                    String path = dwRequestMapping.path();
                    if (!path.startsWith("/") || !this.matchPathPrefix(path)) {
                        path = "/" + path;
                    }
                    orgResourceName = requestMethodName.toUpperCase() + ":" + "/restful/standard/" + moduleName + path;
                } else {
                    String serviceName = targetAPI.getHeader().getServiceName();
                    String methodName = dwMethod.getMethodName();
                    orgResourceName = "/restful/service/" + moduleName + "/" + serviceName + "/" + methodName;
                }
            }
        }
        return orgResourceName;
    }

    private boolean matchPathPrefix(String path) {
        String patternString = "^/.*";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(path);
        return matcher.matches();
    }
}

