/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.interceptor;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.SentinelWebInterceptor;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.SentinelWebMvcConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.digiwin.sentinel.utils.WebExceptionHandlerHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DWSentinelWebInterceptor
extends SentinelWebInterceptor {
    private final SentinelWebMvcConfig config;

    public DWSentinelWebInterceptor() {
        this(new SentinelWebMvcConfig());
    }

    public DWSentinelWebInterceptor(SentinelWebMvcConfig config) {
        super(config);
        this.config = config == null ? new SentinelWebMvcConfig() : config;
    }

    protected String getResourceName(HttpServletRequest request) {
        return super.getResourceName(request);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.increaseReferece(request, this.config.getRequestRefName(), -1) != 0) {
            return;
        }
        Entry entry = this.getEntryInRequest(request, this.config.getRequestAttributeName());
        if (entry == null) {
            RecordLog.warn((String)"[{}] No entry found in request, key: {}", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.config.getRequestAttributeName()});
            return;
        }
        this.traceExceptionAndExit(request, entry, ex);
        this.removeEntryInRequest(request);
        ContextUtil.exit();
    }

    protected void traceExceptionAndExit(HttpServletRequest request, Entry entry, Exception ex) {
        if (entry != null) {
            if (ex != null) {
                Tracer.traceEntry((Throwable)ex, (Entry)entry);
            } else if (this instanceof DWSentinelWebInterceptor) {
                Throwable throwable = WebExceptionHandlerHelper.getCurrentRequestException((HttpServletRequest)request);
                Tracer.traceEntry((Throwable)throwable, (Entry)entry);
            }
            entry.exit();
        }
    }

    private Integer increaseReferece(HttpServletRequest request, String rcKey, int step) {
        Object obj = request.getAttribute(rcKey);
        if (obj == null) {
            obj = 0;
        }
        Integer newRc = (Integer)obj + step;
        request.setAttribute(rcKey, (Object)newRc);
        return newRc;
    }
}

