/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.callback;

import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.callback.BlockExceptionHandler;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class DWBlockExceptionHandler
implements BlockExceptionHandler {
    public void handle(HttpServletRequest request, HttpServletResponse response, String resourceName, BlockException e) throws Exception {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(429);
        String ruleType = e instanceof FlowException ? "FLOW_LIMIT" : (e instanceof DegradeException ? "DEGRADE_LIMIT" : (e instanceof ParamFlowException ? "PARAM_FLOW_LIMIT" : (e instanceof AuthorityException ? "AUTHORITY_LIMIT" : "UNKNOWN")));
        String ruleLimitApp = e.getRuleLimitApp();
        String detailMessage = e.getMessage();
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("code", 429);
        body.put("message", "Request blocked by Sentinel (" + ruleType + ")");
        body.put("ruleType", ruleType);
        body.put("timestamp", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        body.put("ruleLimitApp", ruleLimitApp);
        body.put("detailMessage", detailMessage);
        if (resourceName != null) {
            body.put("resourceName", resourceName);
        }
        String json = this.toJson(body);
        PrintWriter out = response.getWriter();
        out.print(json);
        out.flush();
        out.close();
    }

    private String toJson(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"").append(e.getKey()).append("\":\"").append(e.getValue() == null ? "" : e.getValue().toString().replace("\"", "\\\"")).append("\"");
        }
        sb.append("}");
        return sb.toString();
    }
}

