/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sentinel.adapter.springwebmvc.interceptor;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.SentinelWebInterceptor;
import com.alibaba.csp.sentinel.adapter.spring.webmvc_v6x.config.SentinelWebMvcConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.digiwin.sentinel.adapter.springwebmvc.config.DWSentinelWebMvcConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DWSentinelWebInterceptor
extends SentinelWebInterceptor {
    private final DWSentinelWebMvcConfig config;

    public DWSentinelWebInterceptor() {
        this(new DWSentinelWebMvcConfig());
    }

    public DWSentinelWebInterceptor(DWSentinelWebMvcConfig config) {
        super((SentinelWebMvcConfig)config);
        this.config = config == null ? new DWSentinelWebMvcConfig() : config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String resourceName = "";
        try {
            resourceName = this.getResourceName(request);
            if (StringUtil.isEmpty((String)resourceName)) {
                return true;
            }
            if (this.increaseReference(request, this.config.getRequestRefName(), 1) != 1) {
                return true;
            }
            String origin = this.parseOrigin(request);
            RecordLog.info((String)"check origin, origin is: {}, resourceName is {}", (Object[])new Object[]{origin, resourceName});
            String contextName = this.getContextName(request);
            ContextUtil.enter((String)contextName, (String)origin);
            Entry entry = null;
            List<String> paramKeys = this.config.getParamKeys();
            Map<String, Object> map = this.config.getParamProvider().getFlowControlParams(request);
            if (paramKeys != null && !paramKeys.isEmpty() && map != null && !map.isEmpty()) {
                Object[] paramArray = this.fetchParams(paramKeys, map);
                RecordLog.info((String)"check param flow, param array is: {}", (Object[])paramArray);
                entry = paramArray != null && paramArray.length > 0 ? SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.IN, (Object[])paramArray) : SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.IN);
            } else {
                entry = SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.IN);
            }
            request.setAttribute(this.config.getRequestAttributeName(), (Object)entry);
            return true;
        }
        catch (BlockException e) {
            try {
                this.handleBlockException(request, response, resourceName, e);
            }
            finally {
                ContextUtil.exit();
            }
            return false;
        }
    }

    protected String getResourceName(HttpServletRequest request) {
        Object resourceName = super.getResourceName(request);
        if (StringUtil.isNotEmpty((String)resourceName) && this.config.isHttpMethodSpecify()) {
            resourceName = request.getMethod().toUpperCase() + ":" + (String)resourceName;
        }
        return resourceName;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.exit(request, ex);
    }

    private void exit(HttpServletRequest request, Exception ex) {
        if (this.increaseReference(request, this.config.getRequestRefName(), -1) != 0) {
            return;
        }
        Entry entry = this.getEntryInRequest(request, this.config.getRequestAttributeName());
        if (entry == null) {
            RecordLog.warn((String)"[{}] No entry found in request, key: {}", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.config.getRequestAttributeName()});
            return;
        }
        this.traceExceptionAndExit(entry, ex);
        this.removeEntryInRequest(request);
        ContextUtil.exit();
    }

    protected void traceExceptionAndExit(Entry entry, Exception ex) {
        if (entry == null) {
            return;
        }
        HttpServletRequest request = this.getHttpServletRequest();
        if (request != null && ex == null) {
            if (this.increaseReference(request, this.config.getRequestRefName() + ":" + "$$sentinel_spring_web_entry_attr-exception", 1) == 1) {
                ex = (Exception)request.getAttribute("$$sentinel_spring_web_entry_attr-exception");
            }
        }
        if (ex != null) {
            Tracer.traceEntry((Throwable)ex, (Entry)entry);
        }
        entry.exit();
    }

    private HttpServletRequest getHttpServletRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return Objects.isNull(servletRequestAttributes) ? null : servletRequestAttributes.getRequest();
    }

    private Integer increaseReference(HttpServletRequest request, String rcKey, int step) {
        Object obj = request.getAttribute(rcKey);
        if (obj == null) {
            obj = 0;
        }
        Integer newRc = (Integer)obj + step;
        request.setAttribute(rcKey, (Object)newRc);
        return newRc;
    }

    protected Object[] fetchParams(List<String> keys, Map<String, Object> map) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (String key : keys) {
            Object value = map.get(key);
            params.add(value);
        }
        return params.toArray();
    }
}

