/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission.aop;

import com.digiwin.gateway.service.permission.metadata.DWAPIPermission;
import com.digiwin.gateway.service.permission.metadata.DWDeductCountMode;
import com.digiwin.gateway.service.permission.util.DWAPIPermissionUtil;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWAPIPermissionInterceptor
implements MethodInterceptor {
    private static Log log = LogFactory.getLog(DWAPIPermissionInterceptor.class);
    private DWAPIPermissionUtil dwapiPermissionUtil;

    public DWAPIPermissionInterceptor(DWAPIPermissionUtil dwapiPermissionUtil) {
        Objects.requireNonNull(dwapiPermissionUtil);
        this.dwapiPermissionUtil = dwapiPermissionUtil;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        DWAPIPermission metadata = this.findMetadata(invocation);
        if (metadata == null) {
            if (invocation.getMethod().isAnnotationPresent(DWAPIPermission.class)) {
                log.error((Object)String.format("API permission is not working, because DWAPIPermission only can be annotated on the target method(%s.%s) in the interface!", invocation.getMethod().getDeclaringClass().getName(), invocation.getMethod().getName()));
            } else {
                log.error((Object)String.format("Cannot find DWAPIPermission on method(%s.%s), deduct count function will not work, please contact DAP for this issue!", invocation.getMethod().getDeclaringClass().getName(), invocation.getMethod().getName()));
            }
            return invocation.proceed();
        }
        DWDeductCountMode deductCountMode = this.dwapiPermissionUtil.getDeductCountMode(metadata);
        log.info((Object)String.format("target method(name=%s), deduct count mode=%s", new Object[]{invocation.getMethod().getName(), deductCountMode}));
        if (deductCountMode == DWDeductCountMode.BEFORE_METHOD) {
            this.deductAuthorizationCount(invocation.getThis(), invocation.getMethod(), metadata);
        }
        Object result = invocation.proceed();
        if (deductCountMode == DWDeductCountMode.AFTER_METHOD) {
            this.deductAuthorizationCount(invocation.getThis(), invocation.getMethod(), metadata);
        }
        return result;
    }

    private DWAPIPermission findMetadata(MethodInvocation invocation) {
        Method targetMethod = invocation.getMethod();
        DWAPIPermission metadata = null;
        for (Class<?> interfaceClazz : targetMethod.getDeclaringClass().getInterfaces()) {
            try {
                Method interfaceMethod = interfaceClazz.getMethod(targetMethod.getName(), targetMethod.getParameterTypes());
                if (interfaceMethod == null || (metadata = interfaceMethod.getAnnotation(DWAPIPermission.class)) == null) continue;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return metadata;
    }

    private void deductAuthorizationCount(Object targetObject, Method targetMethod, DWAPIPermission metadata) throws Exception {
        int deductCount = 1;
        String callbackMethodName = metadata.deductCountCallback();
        if (callbackMethodName != null && !callbackMethodName.isEmpty()) {
            Method callbackMethod = targetObject.getClass().getDeclaredMethod(callbackMethodName, new Class[0]);
            if (callbackMethod == null) {
                log.warn((Object)String.format("can not find deduct count callback method(class=%s, method=%s), use default deduct count=1 instead!", targetObject.getClass(), callbackMethodName));
            } else if (callbackMethod.getReturnType() != Integer.TYPE && callbackMethod.getReturnType() != Integer.class) {
                log.warn((Object)String.format("deduct count callback method(class=%s, method=%s) return value type can only be int or Integer, use default deduct count=1 instead!", targetObject.getClass(), callbackMethodName));
            } else {
                try {
                    callbackMethod.setAccessible(true);
                    deductCount = (Integer)callbackMethod.invoke(targetObject, new Object[0]);
                }
                catch (Exception e) {
                    log.error((Object)"deduct count callback failed! use default deduct count=1 instead!", (Throwable)e);
                }
            }
        }
        this.dwapiPermissionUtil.deductAuthorizationCount(deductCount);
    }
}

