/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.service.permission.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class DWSecurityRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body;
    private BufferedReader reader;
    private ServletInputStream inputStream;

    public DWSecurityRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.loadBody(request);
    }

    private void loadBody(HttpServletRequest request) throws IOException {
        int nRead;
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        this.body = buffer.toByteArray();
        this.inputStream = new RequestCachingInputStream(this.body);
    }

    public byte[] getBody() {
        return this.body;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        return super.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.inputStream, this.getCharacterEncoding()));
        }
        return this.reader;
    }

    private static class RequestCachingInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public RequestCachingInputStream(byte[] bytes) {
            this.inputStream = new ByteArrayInputStream(bytes);
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public boolean isFinished() {
            return this.inputStream.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readlistener) {
        }
    }
}

