/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.mq;

import com.dap.component.serviceclient.api.ServiceClientConfigProvider;
import com.dap.component.serviceclient.api.ServiceClientRequestContextProvider;
import com.dap.component.serviceclient.api.ServiceClientServiceProvider;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.serviceclient.mq.DWMqConnection;
import com.digiwin.app.serviceclient.mq.DWMqInfo;
import com.digiwin.app.serviceclient.mq.RabbitMqRestClient;
import com.digiwin.dap.middleware.lmc.LMCClient;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import com.google.gson.reflect.TypeToken;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DeliverCallback;
import java.io.IOException;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.ClientProtocolException;
import org.json.JSONArray;
import org.json.JSONObject;

public class DWMq {
    private static Log log = LogFactory.getLog(DWMq.class);
    private static LMCClient LMCCLIENT_INSTANCE = null;
    private static final String VHOST = "dwmq";
    private static final String PREFIX = "dwmq_";
    private DWMqConnection mqConnection = null;
    private String appId = null;
    private String exchangeName = null;
    private String queueName = null;
    private DWMqInfo mqInfo = null;
    private RabbitMqRestClient rabbitMqRestClient = null;

    public DWMq(String appId, DWMqInfo mqInfo) {
        this.appId = appId;
        this.mqInfo = mqInfo;
    }

    public void init() throws ClientProtocolException, IOException, TimeoutException {
        DWMqConnection mqConnection;
        String prefixAppid;
        this.exchangeName = prefixAppid = this.attachPrefix(this.appId);
        this.queueName = prefixAppid;
        String username = prefixAppid;
        String password = Base64.getEncoder().encodeToString(username.getBytes());
        String basic = this.mqInfo.getBasic();
        String protocol = this.mqInfo.getProtocol();
        String host = this.mqInfo.getHost();
        int port = this.mqInfo.getPort();
        String virtualHost = this.mqInfo.getVirtualHost();
        if (virtualHost == null) {
            virtualHost = VHOST;
        }
        String webPort = this.mqInfo.getWebPort();
        this.rabbitMqRestClient = new RabbitMqRestClient(protocol, host, virtualHost, basic, webPort);
        this.rabbitMqRestClient.createVhost();
        this.rabbitMqRestClient.addVhostPolicy();
        this.rabbitMqRestClient.createUser(username, password);
        this.rabbitMqRestClient.addUserPermission(username);
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setHost(host);
        connectionFactory.setPort(port);
        connectionFactory.setVirtualHost(virtualHost);
        connectionFactory.setUsername(username);
        connectionFactory.setPassword(password);
        this.mqConnection = mqConnection = new DWMqConnection(connectionFactory);
        this.createQueue();
        this.startConsume();
    }

    public void bind(String targetAppId, String event, String groupName, String serviceName, String methodName) throws IOException, TimeoutException {
        String targetExchangeName = this.attachPrefix(targetAppId);
        this.createExchange(targetExchangeName);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("groupName", groupName);
        arguments.put("serviceName", serviceName);
        arguments.put("methodName", methodName);
        this.bindExchange(targetExchangeName, event, arguments);
    }

    public void unbind(String targetAppId, String event) throws IOException, TimeoutException {
        String targetExchangeName = this.attachPrefix(targetAppId);
        JSONArray jsonArray = this.rabbitMqRestClient.getQueueBindings(this.queueName);
        int length = jsonArray.length();
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String source = jsonObject.optString("source", "");
            String routingKey = jsonObject.optString("routing_key", "");
            if (!source.equals(targetExchangeName) || !routingKey.equals(event)) continue;
            JSONObject arguments = jsonObject.optJSONObject("arguments");
            this.unbindExchange(targetExchangeName, event, arguments.toMap());
        }
    }

    public String sendMessage(String targetAppId, String event, Map<String, Object> parameter) throws ClientProtocolException, IOException, TimeoutException {
        String uuid = this.send(targetAppId, event, new HashMap<String, String>(), parameter);
        return uuid;
    }

    public String sendMessage(String targetAppId, String event, Map<String, String> customHeader, Map<String, Object> parameter) throws ClientProtocolException, IOException, TimeoutException {
        String uuid = this.send(targetAppId, event, customHeader, parameter);
        return uuid;
    }

    public String broadcast(String event, Map<String, Object> parameter) throws ClientProtocolException, IOException, TimeoutException {
        String uuid = this.send("", event, new HashMap<String, String>(), parameter);
        return uuid;
    }

    public String broadcast(String event, Map<String, String> customHeader, Map<String, Object> parameter) throws ClientProtocolException, IOException, TimeoutException {
        String uuid = this.send("", event, customHeader, parameter);
        return uuid;
    }

    private String send(String targetAppId, String event, Map<String, String> customHeader, Map<String, Object> parameter) {
        String uuid = UUID.randomUUID().toString();
        String destination = "";
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        try (Channel channel = this.mqConnection.getChannel();){
            String targetQueueName = this.attachPrefix(targetAppId);
            ServiceClientRequestContextProvider requestContextProvider = (ServiceClientRequestContextProvider)SpringContextUtils.getBean((String)"serviceClientRequestContextProvider");
            Map<String, Object> requestHeader = requestContextProvider.getRequestHeader();
            HashMap<String, String> header = new HashMap<String, String>();
            requestHeader.forEach((k, v) -> header.put((String)k, String.valueOf(v)));
            header.putAll(customHeader);
            Map<String, Object> profile = requestContextProvider.getProfile();
            if (profile == null) {
                profile = new HashMap<String, Object>();
            }
            JSONArray jsonArray = this.rabbitMqRestClient.getExchangeBindings(this.exchangeName);
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                destination = "";
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String routingKey = jsonObject.optString("routing_key", "");
                if (!routingKey.equals(event)) continue;
                messageMap = new HashMap();
                destination = jsonObject.optString("destination", "");
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("profile", profile);
                JSONObject arguments = jsonObject.optJSONObject("arguments");
                dataMap.put("arguments", arguments.toMap());
                dataMap.put("source", this.appId);
                dataMap.put("destination", this.unattachPrefix(destination));
                dataMap.put("uuid", uuid);
                dataMap.put("event", event);
                messageMap.put("data", dataMap);
                messageMap.put("header", header);
                messageMap.put("parameter", parameter);
                String message = DWGsonProvider.getGson().toJson(messageMap, new TypeToken<Map<String, Object>>(){}.getType());
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{targetAppId}) && !destination.equals(targetQueueName)) continue;
                channel.basicPublish("", destination, null, message.getBytes("UTF-8"));
                this.saveEventLogOnSend(uuid, messageMap);
            }
        }
        catch (Throwable e) {
            String message = ExceptionUtils.getMessage((Throwable)e);
            log.error((Object)"[DWMq] send exception");
            log.error((Object)("[DWMq] " + message), e);
            this.saveEventLogOnSendException(uuid, this.unattachPrefix(destination), e, messageMap);
        }
        return uuid;
    }

    private void startConsume() throws IOException, TimeoutException {
        Channel channel = this.mqConnection.getChannel();
        DeliverCallback deliverCallback = (consumerTag, delivery) -> {
            String uuid = "";
            HashMap<String, Object> messageMap = new HashMap();
            try {
                channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                String message = new String(delivery.getBody(), "UTF-8");
                messageMap = (Map)DWGsonProvider.getGson().fromJson(message, new TypeToken<Map<String, Object>>(){}.getType());
                Map dataMap = (Map)messageMap.get("data");
                Map arguments = (Map)dataMap.get("arguments");
                String groupName = String.valueOf(arguments.get("groupName"));
                String methodName = String.valueOf(arguments.get("methodName"));
                String serviceName = String.valueOf(arguments.get("serviceName"));
                Map profile = (Map)dataMap.get("profile");
                String source = String.valueOf(dataMap.get("source"));
                uuid = String.valueOf(dataMap.get("uuid"));
                String event = String.valueOf(dataMap.get("event"));
                ServiceClientRequestContextProvider requestContextProvider = (ServiceClientRequestContextProvider)SpringContextUtils.getBean((String)"serviceClientRequestContextProvider");
                requestContextProvider.removeRequestContext();
                requestContextProvider.setProfile(profile);
                Map header = (Map)messageMap.get("header");
                Map parameter = (Map)messageMap.get("parameter");
                header.put("source", source);
                header.put("uuid", uuid);
                header.put("event", event);
                HashMap<String, Map> parameterMap = new HashMap<String, Map>();
                parameterMap.put("headers", header);
                parameterMap.put("messageBody", parameter);
                DWDefaultParameters parameters = new DWDefaultParameters(parameterMap);
                ServiceClientServiceProvider serviceProvider = (ServiceClientServiceProvider)SpringContextUtils.getBean((String)"serviceClientServiceProvider");
                serviceProvider.invoke(groupName, serviceName, methodName, (DWParameters)parameters, profile);
                this.saveEventLogOnConsume(uuid, messageMap);
            }
            catch (Throwable e) {
                String message = ExceptionUtils.getMessage((Throwable)e);
                log.error((Object)"[DWMq] consume exception");
                log.error((Object)("[DWMq] " + message), e);
                this.saveEventLogOnConsumeException(uuid, e, messageMap);
            }
        };
        channel.basicConsume(this.queueName, false, deliverCallback, consumerTag -> {});
    }

    private void createExchange(String exchangeName) throws IOException, TimeoutException {
        try (Channel channel = this.mqConnection.getChannel();){
            channel.exchangeDeclare(exchangeName, BuiltinExchangeType.TOPIC, true);
        }
    }

    private void createQueue() throws IOException, TimeoutException {
        try (Channel channel = this.mqConnection.getChannel();){
            channel.queueDeclare(this.queueName, true, false, false, new HashMap());
        }
    }

    private void bindExchange(String exchangeName, String event, Map<String, Object> arguments) throws IOException, TimeoutException {
        try (Channel channel = this.mqConnection.getChannel();){
            channel.queueBind(this.queueName, exchangeName, event, arguments);
        }
    }

    private void unbindExchange(String exchangeName, String event, Map<String, Object> arguments) throws IOException, TimeoutException {
        try (Channel channel = this.mqConnection.getChannel();){
            channel.queueUnbind(this.queueName, exchangeName, event, arguments);
        }
    }

    private String attachPrefix(String s) {
        s = String.format("dwmq_%s", s);
        return s;
    }

    private String unattachPrefix(String s) {
        s = s.replace(PREFIX, "");
        return s;
    }

    private void saveEventLogOnSend(String uuid, Map<String, Object> message) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("message", message);
        this.saveEventLog("dwmq_send", uuid, 0, content);
    }

    private void saveEventLogOnSendException(String uuid, String destination, Throwable throwable, Map<String, Object> message) {
        String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)throwable);
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)throwable);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("uuid", uuid);
        content.put("destination", destination);
        content.put("rootCauseMessage", rootCauseMessage);
        content.put("stackTrace", stackTrace);
        content.put("message", message);
        this.saveEventLog("dwmq_send", uuid, 1, content);
    }

    private void saveEventLogOnConsume(String uuid, Map<String, Object> message) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("message", message);
        this.saveEventLog("dwmq_consume", uuid, 0, content);
    }

    private void saveEventLogOnConsumeException(String uuid, Throwable throwable, Map<String, Object> message) {
        String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)throwable);
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)throwable);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("uuid", uuid);
        content.put("rootCauseMessage", rootCauseMessage);
        content.put("stackTrace", stackTrace);
        content.put("message", message);
        this.saveEventLog("dwmq_consume", uuid, 1, content);
    }

    private void saveEventLog(String event, String uuid, int status, Map<String, Object> content) {
        try {
            long timestamp = Calendar.getInstance().getTimeInMillis();
            content.put("timestamp", timestamp);
            ServiceClientRequestContextProvider requestContextProvider = (ServiceClientRequestContextProvider)SpringContextUtils.getBean((String)"serviceClientRequestContextProvider");
            String tenantId = requestContextProvider.getTenantId("");
            SaveEventLog saveEventLog = new SaveEventLog();
            saveEventLog.setEventId(uuid);
            saveEventLog.setEventName(event);
            saveEventLog.setEventType(Integer.valueOf(0));
            saveEventLog.setTenantId(tenantId);
            saveEventLog.setStatus(Integer.valueOf(status));
            saveEventLog.setContent(content);
            DWMq.initLmcClient(this.appId);
            LMCCLIENT_INSTANCE.saveEventLog(saveEventLog);
        }
        catch (Exception e) {
            String message = ExceptionUtils.getMessage((Throwable)e);
            log.error((Object)("[DWMq] " + message), (Throwable)e);
        }
    }

    public static void initLmcClient(String appId) {
        if (LMCCLIENT_INSTANCE == null) {
            ServiceClientConfigProvider configProvider = (ServiceClientConfigProvider)SpringContextUtils.getBean((String)"serviceClientConfigProvider");
            String lmcUrl = configProvider.getLmcUrl();
            String appToken = configProvider.getIamApToken();
            String appSecret = null;
            LMCCLIENT_INSTANCE = new LMCClient(lmcUrl, appId, appToken, appSecret);
        }
    }
}

