/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.rpc.concurrent;

import com.dap.component.serviceclient.api.ServiceClientRequestContextProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.serviceclient.rpc.DWDapInvTarget;
import com.digiwin.app.serviceclient.rpc.DWInvMessage;
import com.digiwin.app.serviceclient.rpc.concurrent.DWServiceCallable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class DWServiceCallableBuilder {
    private String appId = null;
    private String moduleName = null;
    private String interfacename = null;
    private String methodName = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Object entity = null;
    private Class<?> resultType = null;

    public static DWServiceCallableBuilder create() {
        DWServiceCallableBuilder builder = new DWServiceCallableBuilder();
        return builder;
    }

    public DWServiceCallableBuilder clear() {
        this.appId = null;
        this.moduleName = null;
        this.interfacename = null;
        this.methodName = null;
        this.headers = new HashMap<String, String>();
        this.parameters = new HashMap<String, Object>();
        this.entity = null;
        this.resultType = null;
        return this;
    }

    public DWServiceCallableBuilder buildInvTarget(String moduleName, String interfaceName, String methodName) throws MalformedURLException, URISyntaxException {
        return this.buildInvTarget(null, moduleName, interfaceName, methodName);
    }

    public DWServiceCallableBuilder buildInvTarget(String appId, String moduleName, String interfaceName, String methodName) throws MalformedURLException, URISyntaxException {
        this.clear();
        this.appId = appId;
        this.moduleName = moduleName;
        this.interfacename = interfaceName;
        this.methodName = methodName;
        return this;
    }

    public DWServiceCallableBuilder addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public DWServiceCallableBuilder addParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public DWServiceCallableBuilder setEntity(Object entity) {
        this.entity = entity;
        return this;
    }

    public DWServiceCallableBuilder setResultType(Class<?> resultType) {
        this.resultType = resultType;
        return this;
    }

    public DWServiceCallable<?> build() throws Exception {
        ServiceClientRequestContextProvider requestContextProvider = (ServiceClientRequestContextProvider)SpringContextUtils.getBean((String)"serviceClientRequestContextProvider");
        this.headers.put("token", requestContextProvider.getToken());
        requestContextProvider.addInnerToken(this.headers);
        String tenantId = (String)requestContextProvider.getTenantId();
        this.headers.put("routerKey", tenantId);
        DWDapInvTarget invTarget = null;
        invTarget = this.appId == null ? DWDapInvTarget.createServiceRouteDapAPI(this.moduleName, this.interfacename, this.methodName) : DWDapInvTarget.createServiceRouteDapAPI(this.appId, this.moduleName, this.interfacename, this.methodName);
        DWInvMessage invMessage = new DWInvMessage();
        HashMap<String, String> newHeaders = new HashMap<String, String>();
        newHeaders.putAll(this.headers);
        invMessage.setHeaders(newHeaders);
        HashMap<String, Object> newParameters = new HashMap<String, Object>();
        newParameters.putAll(this.parameters);
        invMessage.setParameters(newParameters);
        Object newEntity = this.entity;
        invMessage.setEntity(newEntity);
        Class<?> newResultType = this.resultType;
        DWServiceCallable invCallable = new DWServiceCallable(invTarget, invMessage, newResultType);
        return invCallable;
    }
}

