/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.rpc.concurrent;

import com.dap.component.serviceclient.api.ServiceClientRequestContextProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.serviceclient.ServiceClient;
import com.digiwin.app.serviceclient.rpc.DWDapInvTarget;
import com.digiwin.app.serviceclient.rpc.DWInvMessage;
import com.digiwin.app.serviceclient.rpc.DWInvTarget;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.concurrent.Callable;

public class DWServiceCallable<T>
implements Callable<T> {
    private ByteArrayOutputStream _serviceContextByteArrayOutputStream;
    private Map<String, Object> _nonSerializableData;
    private DWDapInvTarget _invTarget;
    private DWInvMessage _message;
    private Class<T> _resultType;

    public DWServiceCallable() {
        try {
            ServiceClientRequestContextProvider requestContextProvider = (ServiceClientRequestContextProvider)SpringContextUtils.getBean((String)"serviceClientRequestContextProvider");
            this._serviceContextByteArrayOutputStream = requestContextProvider.cloneRequestContextAsByteArrayOutputStream();
            this._nonSerializableData = requestContextProvider.getRequestContextNonSerializableData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DWServiceCallable(DWDapInvTarget invTarget, DWInvMessage message, Class<T> resultType) {
        try {
            ServiceClientRequestContextProvider requestContextProvider = (ServiceClientRequestContextProvider)SpringContextUtils.getBean((String)"serviceClientRequestContextProvider");
            this._serviceContextByteArrayOutputStream = requestContextProvider.cloneRequestContextAsByteArrayOutputStream();
            this._nonSerializableData = requestContextProvider.getRequestContextNonSerializableData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._invTarget = invTarget;
        this._message = message;
        this._resultType = resultType;
    }

    @Override
    public T call() throws Exception {
        ServiceClientRequestContextProvider requestContextProvider = (ServiceClientRequestContextProvider)SpringContextUtils.getBean((String)"serviceClientRequestContextProvider");
        requestContextProvider.restoreRequestContext(this._serviceContextByteArrayOutputStream, this._nonSerializableData);
        ServiceClient serviceClient = new ServiceClient();
        T result = serviceClient.invoke((DWInvTarget)this._invTarget, this._message, this._resultType);
        return result;
    }

    public DWDapInvTarget get_invTarget() {
        return this._invTarget;
    }

    public void set_invTarget(DWDapInvTarget _invTarget) {
        this._invTarget = _invTarget;
    }

    public DWInvMessage get_message() {
        return this._message;
    }

    public void set_message(DWInvMessage _message) {
        this._message = _message;
    }

    public Class<T> get_resultType() {
        return this._resultType;
    }

    public void set_resultType(Class<T> _resultType) {
        this._resultType = _resultType;
    }
}

