/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn.util;

import com.dap.component.serviceclient.api.ServiceClientConfigProvider;
import com.dap.component.serviceclient.api.ServiceClientRequestContextProvider;
import com.dap.component.serviceclient.api.ServiceClientSpringContextProvider;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.persistconn.RouteCondition;
import com.digiwin.app.persistconn.TokenProvider;
import com.digiwin.app.persistconn.util.HttpRequestFuse;
import com.digiwin.gateway.fuse.DWFuseExecutor;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.config.OutboundConfig;
import com.digiwin.gateway.fuse.execute.DWFuseOption;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import com.digiwin.gateway.fuse.execute.DWFuseReturnResponse;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.util.DWSecurityTokenUtil;
import io.prometheus.client.CollectorRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.springframework.context.ApplicationContext;

public class DapHttpRequestUtil {
    private static Log log = LogFactory.getLog(DapHttpRequestUtil.class);
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";

    public String httpInvoke(String key, String url, Map<String, Object> parameters, RouteCondition routeCondition) throws Exception {
        ServiceClientRequestContextProvider requestContextProvider;
        Map<String, String> condition;
        String token = TokenProvider.getToken();
        String appToken = TokenProvider.getAppToken();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", CONTENT_TYPE);
        httpPost.addHeader("token", token);
        httpPost.addHeader("digi-middleware-auth-app", appToken);
        DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
        try {
            String securityToken = DWSecurityTokenUtil.generateSecurityToken((DWSecurityContext)securityContext);
            httpPost.addHeader("security-token", securityToken);
        }
        catch (Exception e) {
            log.error((Object)("create security-token error: " + e.getMessage()), (Throwable)e);
        }
        ServiceClientConfigProvider configProvider = (ServiceClientConfigProvider)SpringContextUtils.getBean((String)"serviceClientConfigProvider");
        String iamApSecret = configProvider.getIamApSecret("");
        if (!iamApSecret.trim().isEmpty()) {
            httpPost.addHeader("digi-middleware-auth-app-secret", iamApSecret);
        }
        if (routeCondition != null && (condition = routeCondition.getCondition()).size() != 0) {
            Object cookie = "";
            for (Map.Entry<String, String> entry : condition.entrySet()) {
                String conditionKey = entry.getKey();
                String conditionValue = entry.getValue();
                cookie = (String)cookie + conditionKey + "=" + conditionValue + ";";
            }
            cookie = ((String)cookie).substring(0, ((String)cookie).length() - 1);
            httpPost.addHeader("Cookie", (String)cookie);
        }
        if ((requestContextProvider = (ServiceClientRequestContextProvider)SpringContextUtils.getBean((String)"serviceClientRequestContextProvider")).isProfileNull()) {
            Object tenantId = requestContextProvider.getTenantId();
            httpPost.addHeader("routerKey", tenantId == null ? null : tenantId.toString());
        }
        String jsonString = DWGsonProvider.getGson().toJson(parameters, parameters.getClass());
        StringEntity stringEntity = new StringEntity(jsonString, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)stringEntity);
        OutboundConfig outboundConfig = this.getOutboundConfig(key);
        CollectorRegistry collectorRegistry = null;
        try {
            ServiceClientSpringContextProvider springContextProvider = (ServiceClientSpringContextProvider)SpringContextUtils.getBean((String)"serviceClientSpringContextProvider");
            ApplicationContext applicationContext = springContextProvider.getApplicatioSpringContext();
            collectorRegistry = (CollectorRegistry)applicationContext.getBean(CollectorRegistry.class);
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            String stackTrace = stringWriter.toString();
            log.debug((Object)("[ServiceClient] collectorRegistry: " + e.getMessage()));
            log.debug((Object)("[ServiceClient] collectorRegistry: " + stackTrace));
        }
        outboundConfig.setCollectorRegistry(collectorRegistry);
        HttpRequestFuse httpRequestFuse = new HttpRequestFuse();
        DWFuseParameter fuseParameter = new DWFuseParameter();
        fuseParameter.set("httpPost", (Object)httpPost);
        DWFuseReturnResponse response = new DWFuseReturnResponse((Object)"");
        DWFuseOption option = DWFuseOption.getDefaultOption();
        option.setAutoFuseHttpStatusCode(false);
        log.debug((Object)("[ServiceClient] option: " + String.valueOf(option)));
        response = DWFuseExecutor.execute((DWReturnFuse)httpRequestFuse, (DWFuseParameter)fuseParameter, (OutboundConfig)outboundConfig, (DWFuseOption)option);
        String result = (String)response.getResponse();
        return result;
    }

    public String httpInvoke(String key, String url, Map<String, Object> parameters) throws Exception {
        String result = this.httpInvoke(key, url, parameters, null);
        return result;
    }

    private OutboundConfig getOutboundConfig(String key) {
        return OutboundConfig.create((String)"serviceClient", (String)key);
    }
}

