/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.persistconn.client;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.persistconn.DWResourcePojo;
import com.digiwin.app.persistconn.RouteCondition;
import com.digiwin.app.persistconn.client.DWRpcClient;
import com.digiwin.app.persistconn.util.DapHttpRequestUtil;
import java.util.Map;
import org.springframework.core.env.Environment;

public class InvokeSaasService
extends DWRpcClient {
    private String apName;
    private String moduleName;
    private String serviceName;
    private String methodName;
    private Map<String, Object> parameters;
    private RouteCondition routeCondition;

    public InvokeSaasService(DWResourcePojo pojo) {
        this.apName = pojo.getApName();
        this.moduleName = pojo.getModuleName();
        this.serviceName = pojo.getServiceName();
        this.methodName = pojo.getMethodName();
        this.parameters = pojo.getParameters();
        this.routeCondition = pojo.getRouteCondition();
    }

    @Override
    public String invoke() throws Exception {
        String key = this.moduleName + "." + this.serviceName + "." + this.methodName;
        String[] apNames = this.apName.split("\\.");
        switch (apNames.length) {
            case 1: {
                Environment env = SpringContextUtils.getEnvironment();
                Object urlCase1 = env.getProperty("hybridCloudSaasUrl");
                if (urlCase1 == null) {
                    urlCase1 = env.getProperty("hybridCloudSaaSUrl");
                }
                if (urlCase1 == null) {
                    throw new Exception("no hybridCloudUrlSaas or hybridCloudUrlSaaS");
                }
                urlCase1 = (String)urlCase1 + "/restful/service/" + this.moduleName + "/" + this.serviceName + "/" + this.methodName;
                String responseCase1 = new DapHttpRequestUtil().httpInvoke(key, (String)urlCase1, this.parameters, this.routeCondition);
                return responseCase1;
            }
            case 2: {
                Environment env2 = SpringContextUtils.getEnvironment();
                Object urlCase2 = env2.getProperty("hybridCloudUrlSaas" + apNames[0]);
                if (urlCase2 == null) {
                    urlCase2 = env2.getProperty("hybridCloudUrlSaaS" + apNames[0]);
                }
                if (urlCase2 == null) {
                    throw new Exception("no hybridCloudUrlSaas" + apNames[0] + " or hybridCloudUrlSaaS" + apNames[0]);
                }
                urlCase2 = (String)urlCase2 + "/restful/service/" + this.moduleName + "/" + this.serviceName + "/" + this.methodName;
                String responseCase2 = new DapHttpRequestUtil().httpInvoke(key, (String)urlCase2, this.parameters, this.routeCondition);
                return responseCase2;
            }
        }
        throw new Exception("can't parse apName exception");
    }
}

