/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.serviceclient.mq;

import java.io.IOException;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class RabbitMqRestClient {
    private String protocol = null;
    private String host = null;
    private String vhost = null;
    private String authorization = null;
    private String webPort = null;

    public RabbitMqRestClient(String protocol, String host, String vhost, String basic, String webPort) {
        this.protocol = protocol;
        this.host = host;
        this.vhost = vhost;
        this.authorization = String.format("Basic %s", basic);
        this.webPort = webPort;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONArray getQueueBindings(String queueName) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONArray jsonArray;
            String uri = null;
            uri = this.webPort == null || this.webPort.trim().equals("") ? String.format("%s://%s/api/queues/%s/%s/bindings", this.protocol, this.host, this.vhost, queueName) : String.format("%s://%s:%s/api/queues/%s/%s/bindings", this.protocol, this.host, this.webPort, this.vhost, queueName);
            HttpGet httpGet = new HttpGet(uri);
            httpGet.addHeader("authorization", this.authorization);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            Objects.requireNonNull(response);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                JSONArray jSONArray2 = new JSONArray();
                return jSONArray2;
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONArray jSONArray = jsonArray = new JSONArray(responseBody);
            return jSONArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONArray getExchangeBindings(String exchangeName) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            JSONArray jsonArray;
            String uri = null;
            uri = this.webPort == null || this.webPort.trim().equals("") ? String.format("%s://%s/api/exchanges/%s/%s/bindings/source", this.protocol, this.host, this.vhost, exchangeName) : String.format("%s://%s:%s/api/exchanges/%s/%s/bindings/source", this.protocol, this.host, this.webPort, this.vhost, exchangeName);
            HttpGet httpGet = new HttpGet(uri);
            httpGet.addHeader("authorization", this.authorization);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            Objects.requireNonNull(response);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                JSONArray jSONArray2 = new JSONArray();
                return jSONArray2;
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONArray jSONArray = jsonArray = new JSONArray(responseBody);
            return jSONArray;
        }
    }

    public void createUser(String username, String password) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String uri = null;
            uri = this.webPort == null || this.webPort.trim().equals("") ? String.format("%s://%s/api/users/%s", this.protocol, this.host, username) : String.format("%s://%s:%s/api/users/%s", this.protocol, this.host, this.webPort, username);
            HttpPut httpPut = new HttpPut(uri);
            httpPut.addHeader("authorization", this.authorization);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("password", (Object)password);
            jsonObject.put("tags", (Object)"none");
            StringEntity stringEntity = new StringEntity(jsonObject.toString());
            httpPut.setEntity((HttpEntity)stringEntity);
            httpClient.execute((HttpUriRequest)httpPut);
        }
    }

    public void createVhost() throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String uri = null;
            uri = this.webPort == null || this.webPort.trim().equals("") ? String.format("%s://%s/api/vhosts/%s", this.protocol, this.host, this.vhost) : String.format("%s://%s:%s/api/vhosts/%s", this.protocol, this.host, this.webPort, this.vhost);
            HttpPut httpPut = new HttpPut(uri);
            httpPut.addHeader("authorization", this.authorization);
            httpClient.execute((HttpUriRequest)httpPut);
        }
    }

    public void addVhostPolicy() throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String uri = null;
            uri = this.webPort == null || this.webPort.trim().equals("") ? String.format("%s://%s/api/policies/%s/ha-all", this.protocol, this.host, this.vhost) : String.format("%s://%s:%s/api/policies/%s/ha-all", this.protocol, this.host, this.webPort, this.vhost);
            HttpPut httpPut = new HttpPut(uri);
            httpPut.addHeader("authorization", this.authorization);
            JSONObject definitionJsonObject = new JSONObject();
            definitionJsonObject.put("ha-mode", (Object)"all");
            definitionJsonObject.put("ha-sync-mode", (Object)"automatic");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("pattern", (Object)"");
            jsonObject.put("apply-to", (Object)"all");
            jsonObject.put("definition", (Object)definitionJsonObject);
            StringEntity stringEntity = new StringEntity(jsonObject.toString());
            httpPut.setEntity((HttpEntity)stringEntity);
            httpClient.execute((HttpUriRequest)httpPut);
        }
    }

    public void addUserPermission(String username) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String uri = null;
            uri = this.webPort == null || this.webPort.trim().equals("") ? String.format("%s://%s/api/permissions/%s/%s", this.protocol, this.host, this.vhost, username) : String.format("%s://%s:%s/api/permissions/%s/%s", this.protocol, this.host, this.webPort, this.vhost, username);
            HttpPut httpPut = new HttpPut(uri);
            httpPut.addHeader("authorization", this.authorization);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("configure", (Object)".*");
            jsonObject.put("write", (Object)".*");
            jsonObject.put("read", (Object)".*");
            StringEntity stringEntity = new StringEntity(jsonObject.toString());
            httpPut.setEntity((HttpEntity)stringEntity);
            httpClient.execute((HttpUriRequest)httpPut);
        }
    }
}

