/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.merge.processor;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.beans.factory.BeanInitializationException;

public abstract class DWSourceAppAwarePropertiesWrapperProcessor<T, W extends T> {
    private Class<T> targetBeanType;
    private Class<W> wrapperBeanType;

    public DWSourceAppAwarePropertiesWrapperProcessor() {
        Type[] parameterizedType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.targetBeanType = (Class)parameterizedType[0];
        this.wrapperBeanType = (Class)parameterizedType[1];
    }

    public W wrapper(T bean) throws BeanInitializationException {
        try {
            Constructor<W> constructor = this.wrapperBeanType.getConstructor(this.targetBeanType);
            W wrapperInstance = constructor.newInstance(bean);
            return wrapperInstance;
        }
        catch (Exception e) {
            throw new BeanInitializationException("DWSourceAppAwarePropertiesWrapperProcessor initWrapper failed!", (Throwable)e);
        }
    }

    public Class<T> getTargetBeanType() {
        return this.targetBeanType;
    }

    public Class<W> getWrapperBeanType() {
        return this.wrapperBeanType;
    }
}

