/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.merge.listener;

import com.digiwin.app.merge.DWAppMergedInfo;
import com.digiwin.app.merge.DWSourceAppAwareUtils;
import com.digiwin.app.merge.DWSourceAppInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class DWMultipleAppEnvApplicationStartingListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public static final String CONFIG_KEY_MULTIPLE_APP_ENV = "dap.multiple-app-env";
    @Autowired
    ApplicationContext applicationContext;

    private HashMap<String, Map<String, String>> createDefaultAppMergedInfoMap(DWSourceAppInfo target) {
        HashMap<String, Map<String, String>> infoMap = new HashMap<String, Map<String, String>>();
        infoMap.put(target.getAppId(), Collections.singletonMap("modules", "*"));
        return infoMap;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment env = event.getEnvironment();
        boolean multipleAppEnv = Boolean.parseBoolean(env.getProperty(CONFIG_KEY_MULTIPLE_APP_ENV));
        DWAppMergedInfo mergedInfo = new DWAppMergedInfo();
        DWSourceAppInfo targetAppInfo = new DWSourceAppInfo();
        mergedInfo.setTargetAppInfo(targetAppInfo);
        targetAppInfo.setAppId(env.getProperty("appId"));
        targetAppInfo.setAppToken(env.getProperty("iamApToken"));
        ArrayList<DWSourceAppInfo> otherSourceAppInfoList = new ArrayList<DWSourceAppInfo>();
        mergedInfo.setSourceAppList(otherSourceAppInfoList);
        if (multipleAppEnv) {
            Map mappingResult = (Map)Binder.get((Environment)env).bind("dap.merged.apps", HashMap.class).orElseGet(() -> this.createDefaultAppMergedInfoMap(targetAppInfo));
            HashSet<String> sourceAppAwareConfigKeySet = new HashSet<String>();
            sourceAppAwareConfigKeySet.add("appId");
            for (Map.Entry entry : mappingResult.entrySet()) {
                DWSourceAppInfo appInfo;
                if (((String)entry.getKey()).equalsIgnoreCase(targetAppInfo.getAppId())) {
                    appInfo = targetAppInfo;
                } else {
                    appInfo = new DWSourceAppInfo();
                    otherSourceAppInfoList.add(appInfo);
                    appInfo.setAppId((String)entry.getKey());
                    appInfo.setAppToken((String)((Map)entry.getValue()).get("iamApToken"));
                }
                if (((Map)entry.getValue()).containsKey("modules")) {
                    HashMap conflictModuleNameMap = new HashMap();
                    DWSourceAppInfo finalAppInfo = appInfo;
                    appInfo.setMergedGroupNames(Arrays.stream(((String)((Map)entry.getValue()).get("modules")).split(",")).map(module -> {
                        String conflictSuffix = "_" + finalAppInfo.getAppId();
                        if (module.endsWith(conflictSuffix)) {
                            conflictModuleNameMap.put(module, module.substring(0, module.length() - conflictSuffix.length()));
                        }
                        return module.trim();
                    }).collect(Collectors.toSet()));
                    appInfo.setConflictGroupNames(conflictModuleNameMap);
                } else {
                    appInfo.setMergedGroupNames(Collections.emptySet());
                }
                sourceAppAwareConfigKeySet.addAll(((Map)entry.getValue()).keySet());
            }
            mergedInfo.setSourceAppAwareConfigKeyList(sourceAppAwareConfigKeySet);
        }
        DWSourceAppAwareUtils.setAppMergedInfo((boolean)multipleAppEnv, (DWAppMergedInfo)mergedInfo);
    }

    public int getOrder() {
        return -2147483628;
    }
}

