/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge.processor;

import com.digiwin.app.merge.DWSourceAppAwareUtils;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public class DWSourceAppSwitchProcessor {
    protected void beforeSwitch(String targetAppId) {
    }

    private String switchContextAppId(Supplier<String> switchTargetAppIdSupplier) {
        String switchTargetAppId = switchTargetAppIdSupplier.get();
        this.beforeSwitch(switchTargetAppId);
        String oldContextAppId = DWSourceAppAwareUtils.getContextAppId();
        DWSourceAppAwareUtils.switchContextAppId(switchTargetAppId);
        return oldContextAppId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T process(Supplier<String> switchTargetAppIdSupplier, Callable<T> businessLogic) throws Exception {
        T result;
        String oldContextAppId = null;
        try {
            if (DWSourceAppAwareUtils.isMultipleAppEnvironment()) {
                oldContextAppId = this.switchContextAppId(switchTargetAppIdSupplier);
            }
            result = businessLogic.call();
        }
        finally {
            if (DWSourceAppAwareUtils.isMultipleAppEnvironment()) {
                DWSourceAppAwareUtils.switchContextAppId(oldContextAppId);
            }
        }
        return result;
    }
}

