/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.http;

import com.digiwin.app.http.HttpResponseModel;
import com.digiwin.gateway.fuse.DWReturnFuse;
import com.digiwin.gateway.fuse.exception.DWServerErrorException;
import com.digiwin.gateway.fuse.execute.DWFuseParameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;

public class DWRestfulContainerFuse
implements DWReturnFuse<HttpResponseModel> {
    private static Log log = LogFactory.getLog(DWRestfulContainerFuse.class);

    public HttpResponseModel execute(DWFuseParameter fuseParameter) throws Exception {
        CloseableHttpClient client = (CloseableHttpClient)fuseParameter.get("client");
        HttpPost post = (HttpPost)fuseParameter.get("post");
        String responseBody = "";
        int statusCode = -1;
        Map.Entry entry = (Map.Entry)client.execute((ClassicHttpRequest)post, (HttpClientResponseHandler)new HttpClientResponseHandler<Map.Entry<Integer, String>>(this){

            public Map.Entry<Integer, String> handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
                int statusCode = response.getCode();
                String responseBody = "";
                try (InputStream responseStream = response.getEntity().getContent();){
                    if (responseStream != null) {
                        responseBody = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
                    }
                }
                AbstractMap.SimpleImmutableEntry<Integer, String> entry = new AbstractMap.SimpleImmutableEntry<Integer, String>(statusCode, responseBody);
                return entry;
            }
        });
        responseBody = (String)entry.getValue();
        statusCode = (Integer)entry.getKey();
        if (statusCode == 429 || statusCode == 502 || statusCode == 503 || statusCode == 504) {
            log.warn((Object)("[DWRestfulContainerFuse] HTTP Status Code: " + statusCode + ", result: " + responseBody));
            throw new DWServerErrorException(statusCode, responseBody);
        }
        HttpResponseModel response = new HttpResponseModel(statusCode, responseBody);
        return response;
    }
}

