/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.spring;

import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.DWPropertiesUtils;
import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.gateway.spring.DWSpringResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DWServerSpringResourceReader
extends XmlBeanDefinitionReader {
    private static Log log = LogFactory.getLog(DWServerSpringResourceReader.class);
    public static final String DW_WEBPATH_URL_PREFIX = "dwweb:";
    public static final String ARGUMENT_SPRING_CONFIG_FILE_NAME = "platformSpringConfigFileNames";
    private DWResourcePatternResolver dwResourceLoader = new DWResourcePatternResolver(this);

    public DWServerSpringResourceReader(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public ResourceLoader getResourceLoader() {
        return this.dwResourceLoader;
    }

    public class DWResourcePatternResolver
    extends PathMatchingResourcePatternResolver {
        public DWResourcePatternResolver(DWServerSpringResourceReader this$0) {
        }

        public Resource[] getResources(String locationPattern) throws IOException {
            if (locationPattern.startsWith(DWServerSpringResourceReader.DW_WEBPATH_URL_PREFIX)) {
                String resourceName = locationPattern.split(DWServerSpringResourceReader.DW_WEBPATH_URL_PREFIX)[1];
                String extensionRemoved = resourceName.split("\\.")[0];
                String path = DWPathUtils.getPlatformConfPath();
                Properties properties = DWPropertiesUtils.getProperties(path, extensionRemoved);
                List<String> springConfigs = this.getServerSpringConfigs(properties);
                ArrayList<Resource> resources = new ArrayList<Resource>();
                for (String config : springConfigs) {
                    String xmlString = ConfigPool.getInstance().getPlatformSpringXml(config);
                    ClassLoader classLoader = DWServerSpringResourceReader.class.getClassLoader();
                    DWSpringResource resource = new DWSpringResource(config, xmlString, classLoader);
                    Resource[] rsList = new Resource[]{resource};
                    resources.addAll(Arrays.asList(rsList));
                }
                Resource[] rsArray = new Resource[resources.size()];
                rsArray = resources.toArray(rsArray);
                return rsArray;
            }
            return super.getResources(locationPattern);
        }

        private List<String> getServerSpringConfigs(Properties properties) {
            String[] fileNamesArray;
            ArrayList<String> result = new ArrayList<String>();
            String platformSpringConfigFileNames = properties.getProperty(DWServerSpringResourceReader.ARGUMENT_SPRING_CONFIG_FILE_NAME);
            if (platformSpringConfigFileNames == null || platformSpringConfigFileNames.isEmpty()) {
                return result;
            }
            for (String fileName : fileNamesArray = platformSpringConfigFileNames.split(",")) {
                result.add(fileName);
            }
            for (int i = 0; i < result.size(); ++i) {
                String eachConfigFileName = (String)result.get(i);
                log.info((Object)("> " + i + ". Spring config: " + eachConfigFileName + "."));
            }
            return result;
        }
    }
}

