/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.merge;

import com.digiwin.app.merge.DWSourceAppInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DWAppMergedInfo {
    private Set<String> sourceAppAwareConfigKeys = new HashSet<String>();
    public DWSourceAppInfo targetAppInfo;
    public List<DWSourceAppInfo> sourceAppList;

    public Set<String> getSourceAppAwareConfigKeys() {
        return this.sourceAppAwareConfigKeys;
    }

    public void setSourceAppAwareConfigKeyList(Set<String> sourceAppAwareConfigKeyList) {
        this.sourceAppAwareConfigKeys = sourceAppAwareConfigKeyList;
    }

    public DWSourceAppInfo getTargetAppInfo() {
        return this.targetAppInfo;
    }

    public void setTargetAppInfo(DWSourceAppInfo targetAppInfo) {
        this.targetAppInfo = targetAppInfo;
    }

    public List<DWSourceAppInfo> getSourceAppList() {
        return this.sourceAppList;
    }

    public void setSourceAppList(List<DWSourceAppInfo> sourceAppList) {
        this.sourceAppList = sourceAppList;
    }

    public boolean isTargetApp(String appId) {
        return this.targetAppInfo.getAppId().equalsIgnoreCase(appId);
    }

    public boolean isTargetAppGroup(String groupName) {
        return this.targetAppInfo.getMergedGroupNames().contains(groupName);
    }

    public DWSourceAppInfo getSourceInfo(String appId) {
        if (this.targetAppInfo.getAppId().equals(appId)) {
            return this.targetAppInfo;
        }
        for (DWSourceAppInfo sourceInfo : this.sourceAppList) {
            if (!sourceInfo.getAppId().equals(appId)) continue;
            return sourceInfo;
        }
        return null;
    }

    public DWSourceAppInfo getOwnerApp(String groupName) {
        if (this.targetAppInfo.getMergedGroupNames().contains(groupName)) {
            return this.targetAppInfo;
        }
        for (DWSourceAppInfo appInfo : this.sourceAppList) {
            if (!appInfo.getMergedGroupNames().contains(groupName)) continue;
            return appInfo;
        }
        return this.targetAppInfo;
    }

    public Set<String> getModuleNames() {
        HashSet<String> allModuleNames = new HashSet<String>();
        allModuleNames.addAll(this.targetAppInfo.getMergedGroupNames());
        this.sourceAppList.stream().forEach(s -> allModuleNames.addAll(s.getMergedGroupNames()));
        return allModuleNames;
    }
}

