/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor;

import com.digiwin.app.service.callback.DWServiceChainCallback;
import com.digiwin.app.service.interceptor.DWCallOuterAPIBaseInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWServiceChainExecutorBaseInterceptor<T, C extends DWServiceChainCallback<T>>
implements MethodInterceptor {
    private static Log log = LogFactory.getLog(DWCallOuterAPIBaseInterceptor.class);
    private Class<T> targetArgumentType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private List<C> callbackList;

    public DWServiceChainExecutorBaseInterceptor(List<C> callbackList) {
        this.callbackList = callbackList;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        T targetArgument = this.getTargetArgument(arguments);
        if (targetArgument == null) {
            log.error((Object)String.format("service chain executor target argument(type=%s) is null, could not invoke callback before method!", this.targetArgumentType.getName()));
        } else {
            for (DWServiceChainCallback callback : this.callbackList) {
                callback.before(targetArgument);
            }
        }
        try {
            Object result = invocation.proceed();
            for (DWServiceChainCallback callback : this.callbackList) {
                callback.after(result);
            }
            return result;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            for (DWServiceChainCallback callback : this.callbackList) {
                callback.onError(e);
            }
            throw e;
        }
    }

    protected T getTargetArgument(Object[] arguments) {
        Object targetArgument = null;
        for (Object argument : arguments) {
            if (!this.targetArgumentType.isAssignableFrom(argument.getClass())) continue;
            targetArgument = argument;
            break;
        }
        return (T)targetArgument;
    }
}

