/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor.log;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.core.env.Environment;

public class DWRabbitmqConsumerLogInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DWRabbitmqConsumerLogInterceptor.class);
    private Environment environment;

    public DWRabbitmqConsumerLogInterceptor(Environment environment) {
        this.environment = environment;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        ThreadContext.put((String)"nodeType", (String)"amqp-consumer");
        ThreadContext.put((String)"type", (String)"amqp-consumer-req");
        ThreadContext.put((String)"paramSize", (String)"");
        ThreadContext.put((String)"timeConsume", (String)"");
        Object[] arguments = methodInvocation.getArguments();
        String deliveryTag = "";
        String queue = "";
        for (Object arg : arguments) {
            if (!(arg instanceof Message)) continue;
            Message message = (Message)arg;
            queue = message.getMessageProperties().getConsumerQueue();
            deliveryTag = String.valueOf(message.getMessageProperties().getDeliveryTag());
        }
        logger.info("Start process message with deliveryTag: {}, queue: {}", (Object)deliveryTag, (Object)queue);
        long startTime = System.currentTimeMillis();
        Object result = methodInvocation.proceed();
        long endTime = System.currentTimeMillis();
        long executionTime = endTime - startTime;
        ThreadContext.put((String)"type", (String)"amqp-consumer-resp");
        ThreadContext.put((String)"timeConsume", (String)String.valueOf(executionTime));
        logger.info("Finish process message with deliveryTag: {}, queue: {}", (Object)deliveryTag, (Object)queue);
        return result;
    }
}

