/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.pojo;

import com.digiwin.app.pojo.DWServiceChainTraceElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWServiceChainCurrentElement
extends DWServiceChainTraceElement {
    private static Log log = LogFactory.getLog(DWServiceChainCurrentElement.class);
    private List<DWServiceChainTraceElement> callerStacks;
    private int parentLayer = -1;
    private int selfSeq = 0;
    private int invocationCount = 0;

    public DWServiceChainCurrentElement(String selfAppId, String sessionInfoString) {
        this(selfAppId, false, sessionInfoString);
    }

    public DWServiceChainCurrentElement(String selfAppId, boolean recoveryFromChildInfo, String sessionInfoString) {
        super(selfAppId);
        if (recoveryFromChildInfo) {
            this.recoveryFromChildInfo(sessionInfoString);
        } else {
            this.initialize(sessionInfoString);
        }
    }

    private void recoveryFromChildInfo(String childSessInfoString) {
        try {
            if (childSessInfoString == null) {
                this.callerStacks = Collections.emptyList();
            } else {
                int colonIndex = childSessInfoString.indexOf(":");
                String selfAndParentListString = childSessInfoString.substring(colonIndex + 1);
                List<String> selfAndParentList = Arrays.asList(selfAndParentListString.split(","));
                if (selfAndParentList.size() > 0) {
                    this.callerStacks = Arrays.asList(selfAndParentListString.split(",")).stream().map(part -> DWServiceChainTraceElement.parse(part)).collect(Collectors.toList());
                    DWServiceChainTraceElement selfElement = this.callerStacks.remove(0);
                    this.id = selfElement.id;
                    if (!selfElement.getAppId().equalsIgnoreCase(this.getAppId())) {
                        log.warn((Object)String.format("recoveryFromChildInfo appId[%s] is different from current[%s]!", selfElement.getAppId(), this.getAppId()));
                    }
                    String childInvocationInfo = childSessInfoString.substring(0, colonIndex);
                    String[] infos = childInvocationInfo.split(",");
                    this.parentLayer = Integer.parseInt(infos[0]);
                    if (this.parentLayer > 0) {
                        --this.parentLayer;
                    }
                    this.invocationCount = Integer.parseInt(infos[1]);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)String.format("childSessInfoString is not correct -> %s", childSessInfoString), (Throwable)e);
        }
    }

    private void initialize(String sessionInfoString) {
        try {
            if (sessionInfoString == null) {
                this.callerStacks = Collections.emptyList();
            } else {
                int colonIndex = sessionInfoString.indexOf(":");
                String parentList = sessionInfoString.substring(colonIndex + 1);
                this.callerStacks = Arrays.asList(parentList.split(",")).stream().map(part -> DWServiceChainTraceElement.parse(part)).collect(Collectors.toList());
                String parentInvocationInfo = sessionInfoString.substring(0, colonIndex);
                String[] infos = parentInvocationInfo.split(",");
                this.parentLayer = Integer.parseInt(infos[0]);
                this.selfSeq = Integer.parseInt(infos[1]);
            }
        }
        catch (Exception e) {
            log.error((Object)String.format("sessionInfoString is not correct -> %s", sessionInfoString), (Throwable)e);
        }
    }

    public String getParentId() {
        DWServiceChainTraceElement parent = this.getParent();
        return parent == null ? null : parent.getId();
    }

    public String getParentAppId() {
        DWServiceChainTraceElement parent = this.getParent();
        return parent == null ? null : parent.getAppId();
    }

    public DWServiceChainTraceElement getParent() {
        return this.getParent(0);
    }

    public int getParentLayer() {
        return this.parentLayer;
    }

    public DWServiceChainTraceElement getParent(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index can not less than zero");
        }
        if (this.callerStacks.size() <= index) {
            return null;
        }
        return this.callerStacks.get(index);
    }

    public boolean isRoot() {
        return this.callerStacks.size() == 0;
    }

    public DWServiceChainTraceElement getRoot() {
        if (this.callerStacks.size() > 0) {
            return this.callerStacks.get(this.callerStacks.size() - 1);
        }
        return this;
    }

    public String getRootId() {
        return this.getRoot().getId();
    }

    public int getSeq() {
        return this.selfSeq;
    }

    public int getLayer() {
        return this.parentLayer + 1;
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public int increaseInvocationCount() {
        return ++this.invocationCount;
    }

    public String getTraceInfo(boolean includeSelf) {
        String sessionInfo;
        List parentStackeString = this.callerStacks.stream().map(p -> p.toString()).collect(Collectors.toList());
        String stackString = String.join((CharSequence)" << ", parentStackeString);
        if (includeSelf) {
            if (stackString.length() > 0) {
                stackString = " << " + stackString;
            }
            sessionInfo = String.format("me: %s, seq=%s", super.toString(), this.getSeq()) + stackString;
        } else {
            sessionInfo = stackString;
        }
        sessionInfo = "trace info: " + sessionInfo;
        return sessionInfo;
    }

    @Override
    public String toString() {
        List parentStackeString = this.callerStacks.stream().map(p -> p.toString()).collect(Collectors.toList());
        String stackString = String.join((CharSequence)",", parentStackeString);
        if (stackString.length() > 0) {
            stackString = "," + stackString;
        }
        String sessionInfo = this.getLayer() + "," + this.invocationCount + ":" + super.toString() + stackString;
        return sessionInfo;
    }

    @Override
    public DWServiceChainCurrentElement clone() throws CloneNotSupportedException {
        DWServiceChainCurrentElement clonedElement = (DWServiceChainCurrentElement)super.clone();
        if (this.callerStacks != null) {
            clonedElement.callerStacks = new ArrayList<DWServiceChainTraceElement>();
            for (DWServiceChainTraceElement stackItem : this.callerStacks) {
                clonedElement.callerStacks.add(stackItem.clone());
            }
        }
        return clonedElement;
    }
}

