/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor.log;

import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWTargetAPI;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class DWWebLogHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DWWebLogHandlerInterceptor.class);
    private static final String WEB_PARAM_CONSOLE_ENABLE = "dw.log.web.param-console.enable";
    private static final ThreadLocal<Long> startTime = new ThreadLocal();
    private Environment environment;

    public DWWebLogHandlerInterceptor(Environment environment) {
        this.environment = environment;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String pSpanID = request.getHeader("Pinpoint-pSpanID");
        String spanID = request.getHeader("Pinpoint-SpanID");
        DWTargetAPI targetAPI = (DWTargetAPI)request.getAttribute("targetAPI");
        String nodeId = "";
        if (targetAPI != null) {
            String moduleName = targetAPI.getHeader().getModuleName();
            DWMethod dwMethod = targetAPI.getMethod();
            String serviceName = targetAPI.getHeader().getServiceName();
            String methodName = dwMethod.getMethodName();
            nodeId = moduleName + "." + serviceName + "." + methodName;
        }
        ThreadContext.put((String)"pSpanID", (String)pSpanID);
        ThreadContext.put((String)"nodeType", (String)"web");
        ThreadContext.put((String)"type", (String)"req");
        ThreadContext.put((String)"nodeId", (String)nodeId);
        ThreadContext.put((String)"spanID", (String)spanID);
        String console = this.environment.getProperty(WEB_PARAM_CONSOLE_ENABLE, "false");
        String requestParams = "true".equals(console) ? this.getParams(request) : "";
        String paramSize = String.valueOf(requestParams.getBytes().length);
        ThreadContext.put((String)"paramSize", (String)paramSize);
        ThreadContext.put((String)"timeConsume", (String)"");
        logger.info(requestParams.replaceAll("[\r\n]", ""));
        startTime.set(System.currentTimeMillis());
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        DWTargetAPI targetAPI = (DWTargetAPI)request.getAttribute("targetAPI");
        String nodeId = "";
        if (targetAPI != null) {
            String moduleName = targetAPI.getHeader().getModuleName();
            DWMethod dwMethod = targetAPI.getMethod();
            String serviceName = targetAPI.getHeader().getServiceName();
            String methodName = dwMethod.getMethodName();
            nodeId = moduleName + "." + serviceName + "." + methodName;
        }
        ThreadContext.put((String)"type", (String)"resp");
        ThreadContext.put((String)"nodeId", (String)nodeId);
        ThreadContext.put((String)"nodeType", (String)"web");
        long elapsedTime = System.currentTimeMillis() - startTime.get();
        ThreadContext.put((String)"timeConsume", (String)String.valueOf(elapsedTime));
        long responseSize = this.getResponseSize(response);
        String paramSize = String.valueOf(responseSize);
        ThreadContext.put((String)"paramSize", (String)paramSize);
        String console = this.environment.getProperty(WEB_PARAM_CONSOLE_ENABLE, "false");
        String responseBody = "true".equals(console) ? this.getResponseBody(response) : "";
        logger.info(responseBody);
        startTime.remove();
        ThreadContext.clearAll();
    }

    private long getResponseSize(HttpServletResponse response) throws IOException {
        if (!(response instanceof ContentCachingResponseWrapper)) {
            return 0L;
        }
        ContentCachingResponseWrapper cachedResponse = (ContentCachingResponseWrapper)response;
        byte[] content = cachedResponse.getContentAsByteArray();
        int responseSize = content.length;
        return responseSize;
    }

    private String getParams(HttpServletRequest request) {
        StringBuffer requestBody = new StringBuffer();
        try {
            Map parameterMap = request.getParameterMap();
            if (parameterMap == null || parameterMap.isEmpty()) {
                if ("POST".equalsIgnoreCase(request.getMethod()) || "PUT".equalsIgnoreCase(request.getMethod())) {
                    String line;
                    BufferedReader reader = request.getReader();
                    while ((line = reader.readLine()) != null) {
                        requestBody.append(line.trim());
                    }
                }
            } else {
                ObjectMapper objectMapper = new ObjectMapper();
                requestBody.append(objectMapper.writeValueAsString((Object)parameterMap));
            }
        }
        catch (Exception e) {
            logger.warn("\u5165\u53c2\u89e3\u6790\u5f02\u5e38");
        }
        return requestBody.toString();
    }

    private String getResponseBody(HttpServletResponse response) throws IOException {
        if (!(response instanceof ContentCachingResponseWrapper)) {
            return "";
        }
        ContentCachingResponseWrapper cachedResponse = (ContentCachingResponseWrapper)response;
        byte[] content = cachedResponse.getContentAsByteArray();
        String responseBody = new String(content, cachedResponse.getCharacterEncoding());
        return responseBody;
    }
}

