/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor;

import com.digiwin.app.service.callback.DWServiceChainInitializer;
import com.digiwin.app.service.interceptor.DWCallOuterAPIBaseInterceptor;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWServiceChainInitializerBaseInterceptor<T, C extends DWServiceChainInitializer<T>>
implements MethodInterceptor {
    private static Log log = LogFactory.getLog(DWCallOuterAPIBaseInterceptor.class);
    private Class<T> targetArgumentType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private List<C> initializerList;

    public DWServiceChainInitializerBaseInterceptor(List<C> initializerList) {
        this.initializerList = initializerList;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        T targetArgument = this.getTargetArgument(arguments);
        if (targetArgument == null) {
            log.error((Object)String.format("service chain initializer target argument(type=%s) is null, could not invoke init before method!", this.targetArgumentType.getName()));
        } else {
            for (DWServiceChainInitializer initializer : this.initializerList) {
                initializer.init(targetArgument);
            }
        }
        Object result = invocation.proceed();
        return result;
    }

    protected T getTargetArgument(Object[] arguments) {
        Object targetArgument = null;
        for (Object argument : arguments) {
            if (!this.targetArgumentType.isAssignableFrom(argument.getClass())) continue;
            targetArgument = argument;
            break;
        }
        return (T)targetArgument;
    }
}

