/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor.log;

import java.lang.reflect.Parameter;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DWRedisLogMehodInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DWRedisLogMehodInterceptor.class);
    private Environment environment;

    public DWRedisLogMehodInterceptor(Environment environment) {
        this.environment = environment;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        ThreadContext.put((String)"nodeType", (String)"redis");
        ThreadContext.put((String)"paramSize", (String)"");
        ThreadContext.put((String)"timeConsume", (String)"");
        Parameter[] parameters = methodInvocation.getMethod().getParameters();
        int keyIndex = 0;
        for (int i = 0; i < parameters.length; ++i) {
            String paramName = parameters[i].getName();
            if (!"key".equals(paramName)) continue;
            keyIndex = i;
            break;
        }
        Object[] arg = methodInvocation.getArguments();
        String methodName = methodInvocation.getMethod().getName();
        Object key = arg[keyIndex];
        String keyStr = "";
        keyStr = key instanceof String ? (String)key : (key instanceof Object[] ? Arrays.toString((Object[])key) : String.valueOf(key));
        String nodeId = methodName + "." + keyStr;
        ThreadContext.put((String)"type", (String)"redis-req");
        ThreadContext.put((String)"nodeId", (String)nodeId);
        logger.info("execute " + nodeId);
        long startTime = System.currentTimeMillis();
        Object result = methodInvocation.proceed();
        long endTime = System.currentTimeMillis();
        long executionTime = endTime - startTime;
        ThreadContext.put((String)"type", (String)"redis-resp");
        ThreadContext.put((String)"timeConsume", (String)String.valueOf(executionTime));
        String console = this.environment.getProperty("dw.log.redis.param-console.enable", "false");
        if ("true".equals(console)) {
            logger.info("{}", result);
        } else {
            logger.info("");
        }
        return result;
    }
}

