/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor.log;

import com.digiwin.app.service.callback.DWServiceChainCallback;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DWHttpClientLogCallback
implements DWServiceChainCallback<HttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(DWHttpClientLogCallback.class);
    private static final String HTTP_PARAM_CONSOLE_ENABLE = "dw.log.httpclient.param-console.enable";
    private static final ThreadLocal<Map<String, Object>> logInfoMap = new ThreadLocal();
    private static final ThreadLocal<Long> startTimeHttp = new ThreadLocal();
    private Environment environment;

    public DWHttpClientLogCallback(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void before(HttpRequest context) {
        HashMap<String, String> mapInfo = new HashMap<String, String>();
        String nodeIdOld = ThreadContext.get((String)"nodeId");
        String typeOld = ThreadContext.get((String)"type");
        mapInfo.put("nodeId", nodeIdOld);
        mapInfo.put("type", typeOld);
        logInfoMap.set(mapInfo);
        ThreadContext.put((String)"nodeType", (String)"http");
        ThreadContext.put((String)"type", (String)"req");
        ThreadContext.put((String)"timeConsume", (String)"");
        String requestBody = "";
        String paramSize = "";
        String nodeId = "";
        String console = this.environment.getProperty(HTTP_PARAM_CONSOLE_ENABLE, "false");
        if ("true".equals(console)) {
            if (context instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)context;
                nodeId = request.getRequestLine().getUri().toString();
                try {
                    URI uri = new URI(nodeId);
                    String queryParam = uri.getQuery();
                    requestBody = EntityUtils.toString((HttpEntity)request.getEntity(), (String)"UTF-8") + "|" + queryParam;
                }
                catch (Exception e) {
                    requestBody = "";
                }
            } else if (context instanceof HttpUriRequest) {
                HttpUriRequest httpUriRequest = (HttpUriRequest)context;
                requestBody = httpUriRequest.getURI().getQuery();
                nodeId = httpUriRequest.getURI().toString();
            }
        }
        paramSize = String.valueOf(requestBody.getBytes().length);
        ThreadContext.put((String)"nodeId", (String)nodeId);
        ThreadContext.put((String)"paramSize", (String)paramSize);
        logger.info(requestBody);
        startTimeHttp.set(System.currentTimeMillis());
    }

    @Override
    public void after(Object result) {
        HttpResponse response = (HttpResponse)result;
        String responseBody = "";
        String console = this.environment.getProperty(HTTP_PARAM_CONSOLE_ENABLE, "false");
        if ("true".equals(console)) {
            try {
                responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            catch (IOException e) {
                responseBody = "";
            }
        }
        String paramSize = String.valueOf(responseBody.getBytes().length);
        ThreadContext.put((String)"paramSize", (String)paramSize);
        long elapsedTimeHttp = System.currentTimeMillis() - startTimeHttp.get();
        ThreadContext.put((String)"timeConsume", (String)String.valueOf(elapsedTimeHttp));
        ThreadContext.put((String)"type", (String)"resp");
        logger.info(responseBody);
        String nodeId = logInfoMap.get().get("nodeId") != null ? logInfoMap.get().get("nodeId").toString() : "";
        String type = logInfoMap.get().get("type") != null ? logInfoMap.get().get("type").toString() : "";
        ThreadContext.put((String)"nodeId", (String)nodeId);
        ThreadContext.put((String)"type", (String)type);
        logInfoMap.remove();
        startTimeHttp.remove();
        String pSpanID = ThreadContext.get((String)"pSpanID");
        if (pSpanID == null || "".equals(pSpanID)) {
            ThreadContext.clearAll();
        }
    }

    @Override
    public void onError(Throwable e) {
        long elapsedTimeHttp = System.currentTimeMillis() - startTimeHttp.get();
        ThreadContext.put((String)"timeConsume", (String)String.valueOf(elapsedTimeHttp));
        logger.info("");
        String nodeId = logInfoMap.get().get("nodeId") != null ? logInfoMap.get().get("nodeId").toString() : "";
        String type = logInfoMap.get().get("type") != null ? logInfoMap.get().get("type").toString() : "";
        ThreadContext.put((String)"nodeId", (String)nodeId);
        ThreadContext.put((String)"type", (String)type);
        logInfoMap.remove();
        startTimeHttp.remove();
        String pSpanID = ThreadContext.get((String)"pSpanID");
        if (pSpanID == null || "".equals(pSpanID)) {
            ThreadContext.clearAll();
        }
    }
}

