/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.service.interceptor.log;

import java.lang.reflect.Parameter;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DWDbLogMehodInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DWDbLogMehodInterceptor.class);
    private Environment environment;

    public DWDbLogMehodInterceptor(Environment environment) {
        this.environment = environment;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        ThreadContext.put((String)"nodeType", (String)"db");
        ThreadContext.put((String)"paramSize", (String)"");
        ThreadContext.put((String)"timeConsume", (String)"");
        Parameter[] parameters = methodInvocation.getMethod().getParameters();
        int sqlIndex = 0;
        for (int i = 0; i < parameters.length; ++i) {
            String paramName = parameters[i].getName();
            if (!"sql".equals(paramName)) continue;
            sqlIndex = i;
            break;
        }
        Object[] arg = methodInvocation.getArguments();
        ThreadContext.put((String)"type", (String)"db-req");
        String sql = (String)arg[sqlIndex];
        logger.info(sql);
        long startTime = System.currentTimeMillis();
        Object result = methodInvocation.proceed();
        long endTime = System.currentTimeMillis();
        long executionTime = endTime - startTime;
        ThreadContext.put((String)"type", (String)"db-resp");
        ThreadContext.put((String)"timeConsume", (String)String.valueOf(executionTime));
        String console = this.environment.getProperty("dw.log.db.param-console.enable", "false");
        if ("true".equals(console)) {
            logger.info("{}", result);
        } else {
            logger.info("");
        }
        return result;
    }
}

