/*
 * Decompiled with CFR 0.152.
 */
package dap.framework.service.component.loadbalance;

import com.dap.component.loadbalance.api.LoadbalanceModuleTargetResourceProvider;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.loadbalance.scan.candidate.DWTargetResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class DapLoadbalanceModuleTargetResourceProvider
implements LoadbalanceModuleTargetResourceProvider {
    private Log log = LogFactory.getLog(DapLoadbalanceModuleTargetResourceProvider.class);
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private AntPathMatcher antPathMatcher = new AntPathMatcher();

    public List<DWTargetResource> get(Environment environment, String scanPathsKey) {
        ArrayList<DWTargetResource> dwTargetResourceList = new ArrayList<DWTargetResource>();
        List classPathScanList = (List)environment.getProperty(scanPathsKey, List.class);
        if (!CollectionUtils.isEmpty((Collection)classPathScanList)) {
            for (String path : classPathScanList) {
                Resource[] resources = new Resource[]{};
                try {
                    resources = this.getResources(path);
                }
                catch (IOException e) {
                    this.log.error((Object)("get class path resource fail path:" + path), (Throwable)e);
                }
                dwTargetResourceList.add(new DWTargetResource(null, resources));
            }
        }
        List<String> moduleScanPathList = this.getModuleScanPathList();
        for (String modulePath : moduleScanPathList) {
            Resource[] resources = new Resource[]{};
            try {
                this.creatDummyResource(modulePath, dwTargetResourceList);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                resources = this.getResources(modulePath);
            }
            catch (IOException e) {
                this.log.error((Object)("get module path fail modulePath:" + modulePath), (Throwable)e);
            }
            if (null == resources) continue;
            Arrays.stream(resources).forEach(resource -> {
                String moduleName = this.getModuleName((Resource)resource);
                if (StringUtils.hasText((String)moduleName)) {
                    dwTargetResourceList.add(new DWTargetResource(moduleName, this.resolveModuleResource((Resource)resource)));
                }
            });
        }
        return dwTargetResourceList;
    }

    public final Resource[] getResources(String patternPath) throws IOException {
        this.log.info((Object)("DWResourceHelper search resouce path:" + patternPath));
        if (this.antPathMatcher.isPattern(patternPath)) {
            Object[] jarResources = this.resourcePatternResolver.getResources(patternPath + "/*.jar");
            Object[] classResources = this.resourcePatternResolver.getResources(patternPath + "/*.class");
            Resource[] resources = (Resource[])ArrayUtils.addAll((Object[])jarResources, (Object[])classResources);
            this.log.debug((Object)("DWResourceHelper search resouce path:" + patternPath + " ,resouceLength:" + resources.length));
            return resources;
        }
        Resource partentResouce = this.resourcePatternResolver.getResource(patternPath);
        if (partentResouce.exists() && partentResouce.getFile().isDirectory()) {
            Object[] jarResources = this.resourcePatternResolver.getResources(patternPath + "/**/*.jar");
            Object[] classResources = this.resourcePatternResolver.getResources(patternPath + "/**/*.class");
            Resource[] resources = (Resource[])ArrayUtils.addAll((Object[])jarResources, (Object[])classResources);
            this.log.debug((Object)("DWResourceHelper search resouce path:" + patternPath + " ,resouceLength:" + resources.length));
            return resources;
        }
        Resource[] resources = new Resource[]{partentResouce};
        this.log.debug((Object)("DWResourceHelper search resouce path:" + patternPath + " ,resouceLength:" + resources.length));
        return resources;
    }

    public ResourcePatternResolver getResourcePatternResolver() {
        return this.resourcePatternResolver;
    }

    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }

    private Resource[] resolveModuleResource(Resource moduleResource) {
        List<Object> resources = new ArrayList();
        try {
            resources = this.extractClass(moduleResource);
        }
        catch (IOException e) {
            this.log.error((Object)"error in resolveModuleResource {}", (Throwable)e);
        }
        return resources.toArray(new Resource[0]);
    }

    public List<Resource> extractClass(Resource resource) throws IOException {
        ArrayList<Resource> classResouceList = new ArrayList<Resource>();
        if (resource.exists() && resource.getURL().getProtocol().equals("file") && !resource.getFile().isDirectory()) {
            this.log.debug((Object)("file resource :" + resource + " to extractClass " + "class is " + resource.getClass() + " "));
            if (resource.getFilename().endsWith(".jar")) {
                this.log.debug((Object)("jar resource :" + resource + " to extractClass "));
                List<Resource> jarFileClassResouces = this.getJarFileClassResouces(resource);
                this.log.debug((Object)("jar resource :" + resource + "extractClass length: " + jarFileClassResouces.size()));
                classResouceList.addAll(jarFileClassResouces);
            } else if (resource.getFilename().endsWith(".class")) {
                classResouceList.add(resource);
            }
        } else if (resource.exists() && resource.getURL().getProtocol().equals("jar")) {
            this.log.debug((Object)("inner jar resource :" + resource + " to extractClass "));
            JarURLConnection jarUrlConnection = (JarURLConnection)resource.getURL().openConnection();
            String entryName = jarUrlConnection.getEntryName();
            JarFile jarFile = jarUrlConnection.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!this.getAntPathMatcher().match(entryName + "/**/*.class", jarEntry.getName())) continue;
                classResouceList.add((Resource)new InputStreamResource(jarFile.getInputStream(jarEntry)));
            }
            this.log.debug((Object)("inner resource :" + resource + "extractClass length: " + classResouceList.size()));
        }
        this.log.debug((Object)("resource :" + resource + " getclassLength:" + classResouceList.size()));
        return classResouceList;
    }

    private List<Resource> getJarFileClassResouces(Resource jarResource) throws IOException {
        ArrayList<Resource> classResourceList = new ArrayList<Resource>();
        JarFile jarFile = new JarFile(jarResource.getFile());
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.getName().endsWith(".class")) {
                ByteArrayResource classByteResource = new ByteArrayResource(IOUtils.toByteArray((InputStream)jarFile.getInputStream(jarEntry)));
                classResourceList.add((Resource)classByteResource);
                continue;
            }
            if (!jarEntry.getName().endsWith(".jar")) continue;
            this.readStream(jarFile.getInputStream(jarEntry), classResourceList);
        }
        jarFile.close();
        return classResourceList;
    }

    private List<Resource> readStream(InputStream jarFileInputStream, List<Resource> resourceList) throws IOException {
        ZipInputStream jarInputStream = new ZipInputStream(jarFileInputStream);
        ZipEntry jarEntry = null;
        while (true) {
            byte[] byteArray;
            try {
                jarEntry = jarInputStream.getNextEntry();
                if (jarEntry == null) {
                }
            }
            catch (Throwable e) {}
            break;
            if (jarEntry.getName().endsWith(".class")) {
                byteArray = new byte[]{};
                try {
                    byteArray = DapLoadbalanceModuleTargetResourceProvider.copyStream(jarInputStream, jarEntry);
                }
                catch (IOException e) {
                    continue;
                }
                ByteArrayResource inputStreamSource = new ByteArrayResource(byteArray);
                resourceList.add((Resource)inputStreamSource);
                continue;
            }
            if (!jarEntry.getName().endsWith(".jar")) continue;
            byteArray = new byte[]{};
            try {
                byteArray = DapLoadbalanceModuleTargetResourceProvider.copyStream(jarInputStream, jarEntry);
            }
            catch (IOException e) {
                continue;
            }
            this.readStream(new ByteArrayInputStream(byteArray), resourceList);
        }
        jarInputStream.close();
        return resourceList;
    }

    private static byte[] copyStream(InputStream in, ZipEntry entry) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        long size = entry.getSize();
        if (size > -1L) {
            byte[] buffer = new byte[4096];
            int n = 0;
            for (long count = 0L; -1 != (n = in.read(buffer)) && count < size; count += (long)n) {
                baos.write(buffer, 0, n);
            }
        } else {
            int b;
            while ((b = in.read()) != -1) {
                baos.write(b);
            }
        }
        baos.close();
        return baos.toByteArray();
    }

    public List<String> getModuleScanPathList() {
        ArrayList<String> moduleScanPathList = new ArrayList<String>();
        for (String path : DWModuleSpringUtils.getApplicationModulePaths()) {
            String urlPath = this.getClassPathUrlString(path);
            if (!StringUtils.hasText((String)urlPath)) continue;
            moduleScanPathList.add(urlPath);
        }
        return moduleScanPathList;
    }

    private String getClassPathUrlString(String filePath) {
        try {
            return ResourceUtils.getURL((String)filePath).toString();
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)("file path not found:" + filePath), (Throwable)e);
            return null;
        }
    }

    public String getModuleName(Resource jarResource) {
        Optional<String> anyModuleName;
        String jarResouceUrlString;
        if (jarResource.exists() && jarResource.isFile() && jarResource.getFilename().endsWith(".jar")) {
            Optional<String> anyModuleName2;
            String jarResouceUrlString2 = this.getResouceUrlString(jarResource);
            if (StringUtils.hasText((String)jarResouceUrlString2) && (anyModuleName2 = this.getModuleScanPathList().stream().filter(moduleRoot -> {
                String regex = moduleRoot + "{1,2}(\\S{1,})/{1,2}(\\S{1,}).jar";
                return jarResouceUrlString2.matches(regex);
            }).map(moduleRoot -> {
                String regex = moduleRoot + "{1,2}(\\S{1,})/{1,2}(\\S{1,}).jar";
                Pattern pattern = Pattern.compile(regex);
                Matcher jarMatcher = pattern.matcher(jarResouceUrlString2);
                if (jarMatcher.find()) {
                    return jarMatcher.group(1);
                }
                return null;
            }).findAny()).isPresent()) {
                return anyModuleName2.get();
            }
        } else if (jarResource.exists() && jarResource.isFile() && jarResource.getFilename().endsWith(".class") && StringUtils.hasText((String)(jarResouceUrlString = this.getResouceUrlString(jarResource))) && (anyModuleName = this.getModuleScanPathList().stream().filter(moduleRoot -> {
            String regex = moduleRoot + "{1,2}(\\S{1,})/{1,2}(.{1,}).class";
            return jarResouceUrlString.matches(regex);
        }).map(moduleRoot -> {
            String regex = moduleRoot + "{1,2}(\\S[^/]{1,})/{1,2}(.{1,}).class";
            Pattern pattern = Pattern.compile(regex);
            Matcher jarMatcher = pattern.matcher(jarResouceUrlString);
            if (jarMatcher.find()) {
                return jarMatcher.group(1);
            }
            return null;
        }).findAny()).isPresent()) {
            return anyModuleName.get();
        }
        return null;
    }

    private String getResouceUrlString(Resource resource) {
        if (resource.exists() && resource.isFile()) {
            try {
                return resource.getURL().toString();
            }
            catch (IOException e) {
                this.log.error((Object)("getResouceUrlString can't get resource fileName:" + resource.getFilename()), (Throwable)e);
            }
        }
        return null;
    }

    private void creatDummyResource(String modulePath, List<DWTargetResource> dwTargetResourceList) throws IOException {
        Resource[] moduleResources;
        for (Resource moduleResource : moduleResources = this.getResourcePatternResolver().getResources(modulePath + "/*")) {
            if (!moduleResource.exists() || !moduleResource.isFile() || !moduleResource.getFile().exists() || !moduleResource.getFile().isDirectory()) continue;
            dwTargetResourceList.add(new DWTargetResource(moduleResource.getFilename(), new Resource[0]));
        }
    }
}

