/*
 * Decompiled with CFR 0.152.
 */
package dap.framework.service.component.serviceclient;

import com.dap.component.serviceclient.api.ServiceClientServiceProvider;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWInvocationException;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.serviceclient.exception.DWLocalInvocationException;
import com.digiwin.gateway.output.StandardExceptionOutput;
import com.digiwin.gateway.result.DWResultHandlerList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;

public class DapServiceClientServiceProvider
implements ServiceClientServiceProvider {
    public boolean isContain(String moduleName, String serviceName, String methodName, Map<String, Object> parameters) throws Exception {
        Object service;
        DWMethod method;
        DWContainerContext containerContext = (DWContainerContext)SpringContextUtils.getBean((String)"DWContainerContext");
        DWHeader header = containerContext.getDWHeader(moduleName, serviceName);
        return header != null && (method = containerContext.getDWMethod(header, methodName, (DWParameters)new DWDefaultParameters(parameters))) != null && (service = containerContext.getService(header, method)) != null;
    }

    public String invoke(String moduleName, String serviceName, String methodName, Map<String, Object> parameters) throws Exception {
        HashMap profile = DWServiceContext.getContext().getProfile();
        if (profile == null) {
            profile = new HashMap();
        }
        DWContainerContext containerContext = (DWContainerContext)SpringContextUtils.getBean((String)"DWContainerContext");
        try {
            Object result = containerContext.invoke(moduleName, serviceName, methodName, (DWParameters)new DWDefaultParameters(parameters), profile);
            DWResultHandlerList handler = DWResultHandlerList.getInstance();
            result = handler.process(result);
            return (String)result;
        }
        catch (Throwable e) {
            HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
            if (e instanceof DWException) {
                httpStatus = HttpStatus.BAD_REQUEST;
            }
            Map standardErrorMessage = StandardExceptionOutput.getStandardErrorResult((HttpStatus)httpStatus, (Throwable)e);
            String standardResult = DWGsonProvider.getGson().toJson((Object)standardErrorMessage, standardErrorMessage.getClass());
            return standardResult;
        }
    }

    public void invoke(String moduleName, String serviceName, String methodName, DWParameters parameters, Map<String, Object> profile) throws Exception {
        DWContainerContext containerContext = (DWContainerContext)SpringContextUtils.getBean((String)"DWContainerContext");
        containerContext.invoke(moduleName, serviceName, methodName, parameters, profile);
    }

    public boolean isSameAppContain(String moduleName, String serviceName, String methodName, Object entity) throws DWInvocationException {
        Map mapEntity;
        Object localService = null;
        DWMethod localMethod = null;
        DWDefaultParameters parameters = null;
        DWContainerContext containerContext = (DWContainerContext)SpringContextUtils.getBean((String)"DWContainerContext");
        DWHeader header = containerContext.getDWHeader(moduleName, serviceName);
        if (header != null && (localMethod = containerContext.getDWMethod(header, methodName, (DWParameters)(parameters = new DWDefaultParameters(mapEntity = entity instanceof Map ? (Map)entity : null)))) != null) {
            try {
                localService = containerContext.getService(header, localMethod);
            }
            catch (Exception e) {
                throw new DWLocalInvocationException("get local service failed!", (Throwable)e);
            }
        }
        return localService != null;
    }

    public Object invokeSameApp(String moduleName, String serviceName, String methodName, Object entity) throws DWInvocationException {
        DWContainerContext containerContext = (DWContainerContext)SpringContextUtils.getBean((String)"DWContainerContext");
        Map mapEntity = entity instanceof Map ? (Map)entity : null;
        DWDefaultParameters parameters = new DWDefaultParameters(mapEntity);
        Map profile = DWServiceContext.getContext().getProfile();
        try {
            Object result = containerContext.invoke(moduleName, serviceName, methodName, (DWParameters)parameters, profile);
            return result;
        }
        catch (Exception e) {
            throw new DWLocalInvocationException("invoke local service failed!", (Throwable)e);
        }
    }
}

