/*
 * Decompiled with CFR 0.152.
 */
package dap.framework.service.component.mybatis;

import com.dap.component.mybatis.api.MybatisConfigProviderProvider;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.merge.DWSourceAppAwareUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DapMybatisTenantConfigProvider
implements MybatisConfigProviderProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DapMybatisTenantConfigProvider.class);
    private static final String TENANT_ENABLED_KEY = "tenantEnabled";
    private final Map<String, String> tenantCache = new HashMap<String, String>();

    public String getIAMTenantSidKey() {
        return DWTenantUtils.getIAMTenantSidKey();
    }

    public boolean isTenantenabled() {
        Boolean tenantEnabled = this.getCurGroupAppTenantSign();
        if (Objects.isNull(tenantEnabled)) {
            LOGGER.warn("The source application[appId={}] don't configure 'tenantEnabled'", (Object)DWSourceAppAwareUtils.getSourceAppId((String)DWServiceContext.getContext().getGroupName()));
            return true;
        }
        return tenantEnabled;
    }

    private Boolean getCurGroupAppTenantSign() {
        String configKey = DWSourceAppAwareUtils.getSourceAppConfigKey((String)TENANT_ENABLED_KEY);
        String tenantEnabled = this.getTenantByConfigKey(configKey);
        if (StringUtils.hasText((String)tenantEnabled)) {
            return Boolean.parseBoolean(tenantEnabled);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTenantByConfigKey(String configKey) {
        if (StringUtils.hasText((String)configKey)) {
            if (!this.tenantCache.containsKey(configKey)) {
                DapMybatisTenantConfigProvider dapMybatisTenantConfigProvider = this;
                synchronized (dapMybatisTenantConfigProvider) {
                    if (!this.tenantCache.containsKey(configKey)) {
                        String tenantEnabled = DWApplicationConfigUtils.getProperty((String)configKey);
                        this.tenantCache.put(configKey, tenantEnabled);
                    }
                }
            }
            return this.tenantCache.get(configKey);
        }
        return null;
    }
}

