/*
 * Decompiled with CFR 0.152.
 */
package dap.framework.service.component.schedule;

import com.dap.component.schedule.api.ScheduleServiceProvider;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.schedule.entity.DWJobResult;
import com.digiwin.app.schedule.quartz.job.DWJobInvoker;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.gateway.filter.DWInnerInvocationUtils;
import com.digiwin.iam.HttpRequestModel;
import com.digiwin.iam.HttpRequester;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMHttpRequester;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DapScheduleServiceProvider
implements ScheduleServiceProvider {
    private static final String JOB_INTERFACE = "com.digiwin.app.schedule.quartz.job.DWJob";

    public List<String> getAvailableJobList() {
        ArrayList<String> jobList = new ArrayList<String>();
        DWHeaderRepository repository = (DWHeaderRepository)SpringContextUtils.getBean((String)"DWHeaderRepository");
        List headers = repository.getAllHeader();
        for (DWHeader header : headers) {
            if (!this.isJobHeader(header)) continue;
            jobList.add(header.getServiceName());
        }
        return jobList;
    }

    private boolean isJobHeader(DWHeader header) {
        Class<?> jobServiceClass;
        boolean result = false;
        String moduleName = header.getModuleName();
        Class serviceType = header.getServiceType();
        ClassLoader classLoader = DWModuleClassLoader.getModuleOrUserDefinedClassLoaderByModuleName((String)moduleName);
        if (classLoader == null) {
            return result;
        }
        try {
            jobServiceClass = classLoader.loadClass(JOB_INTERFACE);
        }
        catch (ClassNotFoundException e) {
            return result;
        }
        if (jobServiceClass.isAssignableFrom(serviceType)) {
            result = true;
        }
        return result;
    }

    public DWJobResult invoke(String moduleName, String serviceName, String methodName, DWParameters parameters, Map<String, Object> profile) throws Exception {
        DWContainerContext containerContext = DWContainerContext.getInstance();
        DWJobResult result = (DWJobResult)containerContext.invoke(moduleName, serviceName, "executeJob", parameters, profile);
        return result;
    }

    public HttpResponseModel innerInvoke(String moduleName, String serviceName, String methodName, Map<String, Object> parameters, Map<String, Object> profile) throws Exception {
        HttpResponseModel responseModel = DWInnerInvocationUtils.innerInvoke((String)moduleName, (String)serviceName, (String)methodName, parameters, profile);
        return responseModel;
    }

    public HttpResponseModel outerInvoke(String requestBody, Map<String, String> header, String url) throws Exception {
        HttpRequestModel requestModel = IAMHttpRequester.getHttpRequestModel();
        requestModel.setRequestBody(requestBody);
        requestModel.setRequestHeader(header);
        requestModel.setUrl(url);
        requestModel.setRequestMethod(DWRequestMethod.POST);
        HttpResponseModel responseModel = HttpRequester.submitRequest((HttpRequestModel)requestModel);
        return responseModel;
    }

    public DWJobResult getDwJobResult(HttpResponseModel responseModel) {
        DWJobResult result = null;
        String responseBody = responseModel.getResponseBody();
        DWJobInvoker.DWJobInnerInvocationResult invocationResult = (DWJobInvoker.DWJobInnerInvocationResult)DWInnerInvocationUtils.getGson().fromJson(responseBody, DWJobInvoker.DWJobInnerInvocationResult.class);
        result = invocationResult.getResponse();
        return result;
    }
}

