/*
 * Decompiled with CFR 0.152.
 */
package dap.framework.service.component.dao;

import com.dap.component.dao.api.DaoUpdateDataSource;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.event.DWDataSourceEvent;
import com.digiwin.gateway.event.DWDataSourceEventConfig;
import com.digiwin.gateway.event.DWDataSourceEventParameters;
import com.digiwin.gateway.event.DWDataSourceEventResult;
import com.digiwin.gateway.http.DWRequestWrapper;
import com.digiwin.gateway.result.DWResultHandlerList;
import com.digiwin.gateway.utils.HttpServerletUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;

public class DapDaoUpdateDataSource
implements DaoUpdateDataSource {
    private static Log log = LogFactory.getLog(DapDaoUpdateDataSource.class);
    private static final String KEY_APP_ID = "appId";

    public ResponseEntity<Object> execute(String appId) throws Exception {
        HttpServletRequest httpRequest = HttpServerletUtil.getRequest();
        DWRequestWrapper requestWrapper = new DWRequestWrapper((ServletRequest)httpRequest);
        String body = new String(requestWrapper.getBody(), StandardCharsets.UTF_8);
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new DWBusinessException("body is null");
        }
        DWDataSourceEventParameters orgParameters = new DWDataSourceEventParameters(body);
        Map originalParams = (Map)orgParameters.getPararmeters().get("params");
        if (originalParams.containsKey(KEY_APP_ID)) {
            String appIdInBody = (String)originalParams.get(KEY_APP_ID);
            if (!appId.equals(appIdInBody)) {
                throw new DWBusinessException("request body appId(" + appIdInBody + ") not equal to " + appId);
            }
        } else {
            throw new DWBusinessException("request body no appId");
        }
        DWResultHandlerList handler = DWResultHandlerList.getInstance();
        ArrayList<DWDataSourceEventResult> resultList = new ArrayList<DWDataSourceEventResult>();
        List eventList = DWDataSourceEventConfig.getEventList();
        for (DWDataSourceEvent event : eventList) {
            DWDataSourceEventResult result;
            try {
                result = (DWDataSourceEventResult)event.doInvoke((DWDefaultParameters)orgParameters);
                resultList.add(result);
            }
            catch (Exception e) {
                log.error((Object)(event.getClass().getName() + ".doInvoke exception occured!"), (Throwable)e);
                result = new DWDataSourceEventResult(event, e);
                resultList.add(result);
            }
        }
        boolean success = !resultList.stream().anyMatch(item -> !item.isSuccess());
        Object finalResult = DWServiceResultBuilder.build((boolean)success, (String)"done!", resultList);
        finalResult = handler.process(finalResult);
        Map headerMap = DWServiceContext.getContext().getResponseHeader();
        HttpHeaders responseHeaders = new HttpHeaders();
        for (String key : headerMap.keySet()) {
            responseHeaders.add(key, String.valueOf(headerMap.getOrDefault(key, "")));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body(finalResult);
    }
}

