/*
 * Decompiled with CFR 0.152.
 */
package dap.framework.service.component.serviceclient;

import com.dap.component.serviceclient.api.ServiceClientRequestContextProvider;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.gateway.filter.DWInnerInvocationUtils;
import com.digiwin.utils.DWTenantUtils;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DapServiceClientRequestContextProvider
implements ServiceClientRequestContextProvider {
    public boolean isProfileNull() {
        Map profile = DWServiceContext.getContext().getProfile();
        boolean isNull = profile != null;
        return isNull;
    }

    public String getTenantSid(String defaultValue) {
        Map profile = DWServiceContext.getContext().getProfile();
        Optional<Object> profileOptional = profile == null ? Optional.empty() : Optional.of(profile);
        String tenantSid = String.valueOf(((Map)profileOptional.orElse(new HashMap())).getOrDefault("tenantSid", defaultValue));
        return tenantSid;
    }

    public void setProfile(Map<String, Object> profile) {
        DWServiceContext.getContext().setProfile(profile);
    }

    public void removeRequestContext() {
        DWServiceContext.getContext().remove();
    }

    public ByteArrayOutputStream cloneRequestContextAsByteArrayOutputStream() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = DWServiceContext.getContext().deepCloneAsByteArrayOutputStream();
        return byteArrayOutputStream;
    }

    public Map<String, Object> getRequestContextNonSerializableData() {
        Map nonSerializableData = DWServiceContext.getContext().getNonSerializableData();
        return nonSerializableData;
    }

    public void restoreRequestContext(ByteArrayOutputStream byteArrayOutputStream, Map<String, Object> nonSerializableData) throws Exception {
        DWServiceContext.setContext((ByteArrayOutputStream)byteArrayOutputStream, nonSerializableData);
    }

    public boolean isRequestHeaderContainCookie() {
        Map requestHeader = DWServiceContext.getContext().getRequestHeader();
        boolean contain = requestHeader.containsKey("Cookie") || requestHeader.containsKey("cookie");
        return contain;
    }

    public String getRequestHeaderCookie() {
        Map requestHeader = DWServiceContext.getContext().getRequestHeader();
        String cookieFromHeader = String.valueOf(requestHeader.getOrDefault("Cookie", requestHeader.get("cookie")));
        return cookieFromHeader;
    }

    public String getDigiMiddlewareAuthApp(String defaultValue) {
        String appToken = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-auth-app", defaultValue);
        return appToken;
    }

    public String getTenantIdByIamTenantIdKey() {
        DWServiceContext context = DWServiceContext.getContext();
        String tenantId = (String)context.getProfile().get(DWTenantUtils.getIamTenantIdKey());
        return tenantId;
    }

    public String getTenantId(String defaultValue) {
        Map profile = DWServiceContext.getContext().getProfile();
        Optional<Object> profileOptional = profile == null ? Optional.empty() : Optional.of(profile);
        String tenantId = String.valueOf(((Map)profileOptional.orElse(new HashMap())).getOrDefault("tenantId", defaultValue));
        return tenantId;
    }

    public Object getTenantId() {
        Map profile = DWServiceContext.getContext().getProfile();
        Object tenantId = profile.get("tenantId");
        return tenantId;
    }

    public String getToken() {
        String token = DWServiceContext.getContext().getToken();
        return token;
    }

    public void setToken(String token) {
        DWServiceContext.getContext().setToken(token);
    }

    public void addInnerToken(Map<String, String> headers) {
        DWServiceContext context = DWServiceContext.getContext();
        String innerToken = DWInnerInvocationUtils.getInnerToken((Map)context.getProfile());
        headers.put(DWInnerInvocationUtils.HEADER_KEY_INNER_TOKEN, innerToken);
    }

    public Map<String, Object> getRequestHeader() {
        Map requestHeader = DWServiceContext.getContext().getRequestHeader();
        return requestHeader;
    }

    public Map<String, Object> getProfile() {
        Map profile = DWServiceContext.getContext().getProfile();
        return profile;
    }
}

