/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.developer.definer;

import com.digiwin.app.module.utils.DWDeveloperServiceCSVReader;
import com.digiwin.app.module.utils.DWDeveloperServicePathManager;
import com.digiwin.app.service.DWService;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.csv.CSVRecord;

public abstract class DWDeveloperBaseRepositoryDefiner {
    protected abstract void onDeveloperDWServiceFind(String var1, Class<?> var2, Class<?> var3) throws Exception;

    protected void scanDeveloperDWService() throws Exception {
        List<CSVRecord> csvRecords = new DWDeveloperServiceCSVReader().getCSVRecords();
        for (CSVRecord record : csvRecords) {
            if (!Boolean.valueOf(record.get("isAvailable")).booleanValue()) continue;
            String moduleName = record.get("moduleName");
            String implementPath = record.get("implementPath");
            DWDeveloperServicePathManager pathManager = new DWDeveloperServicePathManager(implementPath);
            if (pathManager.isPathClass()) {
                Class<?> implementationType = Class.forName(implementPath);
                this.scanDWServiceInterfaces(moduleName, implementationType);
                continue;
            }
            JarFile jarFile = new JarFile(pathManager.getJarPath());
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                String path = entry.getName();
                if (!(path = DWDeveloperServicePathManager.pathNormalization(path)).contains(implementPath.replace(".", File.separator)) || !path.contains(".class")) continue;
                String classPath = path.replace(File.separator, ".").replace(".class", "");
                Class<?> implementationType = Class.forName(classPath);
                this.scanDWServiceInterfaces(moduleName, implementationType);
            }
            jarFile.close();
        }
    }

    private void scanDWServiceInterfaces(String moduleName, Class<?> implementationType) throws Exception {
        Class<?>[] interfaces;
        for (Class<?> interfaceType : interfaces = implementationType.getInterfaces()) {
            Class<?>[] parentInterfaces;
            for (Class<?> parentInterface : parentInterfaces = interfaceType.getInterfaces()) {
                if (!DWService.class.getName().equals(parentInterface.getName())) continue;
                this.onDeveloperDWServiceFind(moduleName, interfaceType, implementationType);
            }
        }
    }
}

