/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.module.spring;

import com.digiwin.app.common.DWApplicationSpringUtils;
import com.digiwin.app.common.DWPathUtils;
import com.digiwin.app.common.DWPropertiesUtils;
import com.digiwin.app.common.config.ConfigPool;
import com.digiwin.app.container.exceptions.DWModuleSusspendedException;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModuleConfigUtils;
import com.digiwin.app.module.DWModuleResourceUtils;
import com.digiwin.app.module.DWModuleSpringInfo;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.app.module.spring.boot.DWModuleSpringApplication;
import com.digiwin.app.module.spring.scanner.DWModuleSpringBootAppScanner;
import com.digiwin.app.module.spring.scanner.DWModuleSpringConfigScanner;
import com.digiwin.app.module.spring.scanner.SpringConfigScanner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.WebApplicationType;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public final class DWModuleSpringUtils {
    private static Log _log = LogFactory.getLog(DWModuleSpringUtils.class);
    private static Map<String, ApplicationContext> _moduleContexts = new HashMap<String, ApplicationContext>();
    private static Map<String, String[]> _moduleSpringConfigs = new HashMap<String, String[]>();
    private static Map<String, DWModuleSpringInfo> _moduleSpringInfos = new HashMap<String, DWModuleSpringInfo>();
    private static Map<String, Exception> _springConfigLoadFailedModuleList = new HashMap<String, Exception>();
    private static List<SpringConfigScanner> springConfigScanners = new ArrayList<SpringConfigScanner>();
    private static DWModuleSpringBootAppScanner springBootAppScanner = DWModuleSpringUtils.initScanner();
    private static List<Class<?>> moduleConfigClassList = new ArrayList();
    private static List<BiConsumer<String, GenericXmlApplicationContext>> moduleBeforeRefreshListenerList = new ArrayList<BiConsumer<String, GenericXmlApplicationContext>>();

    public DWModuleSpringUtils() {
        List<String> platformModulePaths = DWModuleSpringUtils.getPlatformModulePaths();
        List<String> applicationModulePaths = DWModuleSpringUtils.getApplicationModulePaths();
        DWModuleSpringConfigScanner moduleSpringConfigScanner = new DWModuleSpringConfigScanner(platformModulePaths, applicationModulePaths);
        springConfigScanners.add(moduleSpringConfigScanner);
        DWModuleSpringUtils.doScan();
    }

    public static List<String> getPlatformModulePaths() {
        ArrayList<String> platformModulePaths = new ArrayList<String>();
        platformModulePaths.add(DWPathUtils.getPlatformModulePath());
        return platformModulePaths;
    }

    public static List<String> getApplicationModulePaths() {
        ArrayList<String> applicationModulePaths = new ArrayList<String>();
        applicationModulePaths.add(DWPathUtils.getApplicationModulePath());
        applicationModulePaths.add(DWPathUtils.getIndustryModulePath());
        applicationModulePaths.add(DWPathUtils.getCustomizationModulePath());
        return applicationModulePaths;
    }

    private static DWModuleSpringBootAppScanner initScanner() {
        ArrayList<String> platformModulePaths = new ArrayList<String>();
        List<String> applicationModulePaths = DWModuleSpringUtils.getApplicationModulePaths();
        return new DWModuleSpringBootAppScanner(platformModulePaths, applicationModulePaths);
    }

    private static void doScan() {
        for (SpringConfigScanner springConfigScanner : springConfigScanners) {
            Map<String, String[]> moduleSpringConfig = springConfigScanner.doScan();
            _moduleSpringConfigs.putAll(moduleSpringConfig);
            DWModuleSpringUtils.refreshModuleSpringInfos(moduleSpringConfig);
        }
        Map primarySources = (Map)springBootAppScanner.scan();
        DWModuleSpringUtils.refreshModuleSpringBootInfos(primarySources);
    }

    private static void doScan(String moduleName) {
        _log.info((Object)String.format("[Module=%s, springConfigScanners=%s] do scan...", moduleName, springConfigScanners));
        for (SpringConfigScanner springConfigScanner : springConfigScanners) {
            Map<String, String[]> moduleSpringConfig = springConfigScanner.doScan(moduleName);
            _moduleSpringConfigs.putAll(moduleSpringConfig);
            _log.info((Object)String.format(">> module(%s) do scan update configs = %s", moduleName, moduleSpringConfig));
            DWModuleSpringUtils.refreshModuleSpringInfos(moduleSpringConfig);
            _log.info((Object)String.format(">> module(%s) after do scan update configs, springInfo map = %s", moduleName, _moduleSpringInfos));
        }
        Map primarySources = (Map)springBootAppScanner.scan(moduleName);
        _log.info((Object)String.format(">> module(%s) spring boot resource scan result = %s", moduleName, primarySources));
        DWModuleSpringUtils.refreshModuleSpringBootInfos(primarySources);
    }

    private static void refreshModuleSpringInfos(Map<String, String[]> springConfigs) {
        for (Map.Entry<String, String[]> item : springConfigs.entrySet()) {
            String moduleName = item.getKey();
            DWModuleSpringInfo springInfo = _moduleSpringInfos.get(moduleName);
            if (springInfo == null) {
                springInfo = new DWModuleSpringInfo(moduleName);
                _moduleSpringInfos.put(moduleName, springInfo);
            }
            springInfo.setConfigs(item.getValue());
        }
    }

    private static void refreshModuleSpringBootInfos(Map<String, List<Class<?>>> primarySources) {
        for (Map.Entry<String, List<Class<?>>> item : primarySources.entrySet()) {
            String moduleName = item.getKey();
            DWModuleSpringInfo springInfo = _moduleSpringInfos.get(moduleName);
            if (springInfo == null) {
                springInfo = new DWModuleSpringInfo(moduleName);
                _moduleSpringInfos.put(moduleName, springInfo);
            }
            Class[] psArray = new Class[item.getValue().size()];
            psArray = item.getValue().toArray(psArray);
            springInfo.setAppPrimarySource(psArray);
        }
    }

    public static void registerModuleConfigurationClass(Class<?> moduleConfigClass) {
        if (moduleConfigClass == null) {
            return;
        }
        moduleConfigClassList.add(moduleConfigClass);
    }

    public static void registerModuleBeforeRefreshListener(BiConsumer<String, GenericXmlApplicationContext> consumer) {
        moduleBeforeRefreshListenerList.add(consumer);
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized ApplicationContext getModuleSpringContext(String moduleName) {
        if (_springConfigLoadFailedModuleList.containsKey(moduleName)) {
            DWModuleSpringUtils.throwModuleSusspendException(moduleName, _springConfigLoadFailedModuleList.get(moduleName));
        }
        if (_moduleContexts.containsKey(moduleName)) {
            return _moduleContexts.get(moduleName);
        }
        DWModuleSpringInfo springInfo = _moduleSpringInfos.get(moduleName);
        ConfigurableApplicationContext context = null;
        DWModuleClassLoader.setCurrentModuleName(moduleName);
        DWModuleClassLoader classLoader = DWModuleClassLoader.getModuleClassLoaderByModuleName(moduleName);
        if (classLoader != null) {
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)((Object)classLoader));
                if (springInfo == null) {
                    _log.error((Object)String.format("DWModuleSpringUtils getModuleSpringContext(module=%s) springInfo is null! try to load springInfo...", moduleName));
                    DWModuleSpringUtils.refresh(moduleName);
                    springInfo = _moduleSpringInfos.get(moduleName);
                    if (springInfo == null) {
                        _log.error((Object)String.format("DWModuleSpringUtils getModuleSpringContext(module=%s) springInfo is still null after refresh!", moduleName));
                    }
                }
                if (springInfo.isModuleSpringApplication()) {
                    DWModuleSpringApplication app = new DWModuleSpringApplication(moduleName, springInfo.getAppPrimarySource());
                    app.setParentContext(DWApplicationSpringUtils.getContext());
                    app.setWebApplicationType(WebApplicationType.NONE);
                    app.setDefaultProperties(new Properties());
                    context = app.run(new String[0]);
                } else {
                    GenericApplicationContext parentContext;
                    ConfigPool pool = ConfigPool.getInstance();
                    boolean isPlatformModule = false;
                    String modulePath = DWPathUtils.getApplicationModulePath((String)moduleName);
                    String springConfigFileNames = null;
                    if (new File(modulePath).exists()) {
                        springConfigFileNames = DWModuleConfigUtils.getProperty(moduleName, "springConfigFileNames", null);
                    } else {
                        springConfigFileNames = DWPropertiesUtils.getPlatformModuleProperty("module", moduleName, "springConfigFileNames", null);
                        isPlatformModule = true;
                    }
                    ArrayList<InputStreamResource> resources = new ArrayList<InputStreamResource>();
                    if (springConfigFileNames != null) {
                        String[] springConfigFileNameArray = springConfigFileNames.split(",");
                        for (int i = 0; i < springConfigFileNameArray.length; ++i) {
                            void var12_16;
                            String springConfigFileName = springConfigFileNameArray[i];
                            Object var12_17 = null;
                            if (isPlatformModule) {
                                String string = pool.getModuleSpringXml(moduleName, springConfigFileName);
                            } else {
                                String string = DWModuleResourceUtils.getResourceString(springConfigFileName, moduleName);
                            }
                            if (StringUtils.isBlank((CharSequence)var12_16)) continue;
                            byte[] byteArray = var12_16.getBytes("UTF-8");
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
                            resources.add(new InputStreamResource((InputStream)byteArrayInputStream));
                        }
                    } else {
                        String xmlString = null;
                        xmlString = isPlatformModule ? pool.getModuleSpringXml(moduleName, "spring-module.xml") : DWModuleResourceUtils.getResourceString("spring-module.xml", moduleName);
                        if (!StringUtils.isBlank((CharSequence)xmlString)) {
                            byte[] byteArray = xmlString.getBytes("UTF-8");
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
                            resources.add(new InputStreamResource((InputStream)byteArrayInputStream));
                        }
                    }
                    InputStreamResource[] inputStreamResourceArray = resources.toArray(new InputStreamResource[resources.size()]);
                    GenericXmlApplicationContext genericXmlApplicationContext = new GenericXmlApplicationContext();
                    genericXmlApplicationContext.setClassLoader((ClassLoader)((Object)classLoader));
                    genericXmlApplicationContext.setParent(DWApplicationSpringUtils.getContext());
                    genericXmlApplicationContext.setValidating(false);
                    for (Class clazz : moduleConfigClassList) {
                        AnnotatedGenericBeanDefinition configBeanDef = new AnnotatedGenericBeanDefinition(clazz);
                        genericXmlApplicationContext.registerBeanDefinition(configBeanDef.getBeanClassName(), (BeanDefinition)configBeanDef);
                    }
                    if (inputStreamResourceArray.length > 0) {
                        genericXmlApplicationContext.load((Resource[])inputStreamResourceArray);
                    }
                    if ((parentContext = (GenericApplicationContext)SpringContextUtils.getContext()).containsBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator") && !genericXmlApplicationContext.containsBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator")) {
                        BeanDefinition beanDefinition = parentContext.getBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator");
                        genericXmlApplicationContext.registerBeanDefinition("org.springframework.aop.config.internalAutoProxyCreator", beanDefinition);
                    }
                    moduleBeforeRefreshListenerList.forEach(c -> c.accept(moduleName, genericXmlApplicationContext));
                    String string = System.getenv().get("dap_module_application_context_eager_cache");
                    if (string == null || Boolean.parseBoolean(string)) {
                        _moduleContexts.put(moduleName, (ApplicationContext)genericXmlApplicationContext);
                    }
                    genericXmlApplicationContext.refresh();
                    context = genericXmlApplicationContext;
                }
            }
            catch (Exception e) {
                _springConfigLoadFailedModuleList.put(moduleName, e);
                _log.error((Object)("Module Config Load failed! moduleName = " + moduleName), (Throwable)e);
                DWModuleSpringUtils.throwModuleSusspendException(moduleName, e);
            }
        }
        _moduleContexts.put(moduleName, (ApplicationContext)context);
        return context;
    }

    public static <T> T getBean(Object moduleService, String name) {
        Object result = null;
        ClassLoader loader = moduleService.getClass().getClassLoader();
        String moduleName = DWModuleClassLoader.getModuleName(loader);
        ApplicationContext moduleContext = DWModuleSpringUtils.getModuleSpringContext(moduleName);
        if (moduleContext == null) {
            DWModuleSpringUtils.throwModuleSpringNotSettingException(moduleName);
        } else {
            result = moduleContext.getBean(name);
        }
        return (T)result;
    }

    public static <T> T getBean(String moduleName, String name) {
        Object result = null;
        ApplicationContext moduleContext = DWModuleSpringUtils.getModuleSpringContext(moduleName);
        if (moduleContext == null) {
            DWModuleSpringUtils.throwModuleSpringNotSettingException(moduleName);
        } else {
            result = moduleContext.getBean(name);
        }
        return (T)result;
    }

    public static boolean containsBean(String moduleName, String name) {
        boolean result = false;
        ApplicationContext moduleContext = DWModuleSpringUtils.getModuleSpringContext(moduleName);
        if (moduleContext == null) {
            DWModuleSpringUtils.throwModuleSpringNotSettingException(moduleName);
        } else {
            result = moduleContext.containsBean(name);
        }
        return result;
    }

    private static void throwModuleSpringNotSettingException(String moduleName) throws IllegalStateException {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("This Module '").append(moduleName).append("'").append(" has not set any Spring Configurations.");
        throw new IllegalStateException(errorMessage.toString());
    }

    private static void throwModuleSusspendException(String moduleName, Throwable cause) {
        throw new DWModuleSusspendedException(moduleName, cause);
    }

    public static Map<String, ApplicationContext> getSpringContexts() {
        return _moduleContexts;
    }

    public static List<String> getModuleNameList() {
        return new ArrayList<String>(_moduleSpringInfos.keySet());
    }

    public static void refresh(String moduleName) {
        _moduleContexts.remove(moduleName);
        _springConfigLoadFailedModuleList.remove(moduleName);
        DWModuleSpringUtils.doScan(moduleName);
    }

    public static void stop() {
        _moduleContexts.values().forEach(applicationContext -> {
            if (applicationContext instanceof Lifecycle) {
                ((Lifecycle)applicationContext).stop();
            }
        });
    }
}

