/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.mock;

import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.local.mock.DWMockData;
import com.digiwin.app.container.local.mock.DWMockParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DWMockMethod
extends DWMethod {
    private List<DWMockData> mockDatas = new ArrayList<DWMockData>();
    private List<DWMockParameter> parameters;
    private String mockTargetMethodName;
    private String mockInfo;
    private String requestUrl;

    public DWMockMethod(Method method, String mockTargetMethodName, String requestUrl, List<DWMockParameter> parameters) {
        super(method);
        if (mockTargetMethodName == null || mockTargetMethodName.isEmpty()) {
            throw new IllegalArgumentException("mockTargetMethodName is null!");
        }
        this.mockTargetMethodName = mockTargetMethodName;
        this.requestUrl = requestUrl;
        this.parameters = parameters == null ? Collections.emptyList() : parameters;
    }

    public void setMockInfo(String mockInfo) {
        this.mockInfo = mockInfo;
    }

    public String getMockInfo() {
        return this.mockInfo;
    }

    public void addMockData(DWMockData mockData) {
        this.mockDatas.add(mockData);
    }

    public void addAllMockDatas(Collection<DWMockData> mockDatas) {
        this.mockDatas.addAll(mockDatas);
    }

    public List<DWMockData> getMockDatas() {
        return Collections.unmodifiableList(this.mockDatas);
    }

    @Override
    public String getMethodName() {
        return this.mockTargetMethodName;
    }

    @Override
    public boolean allowAnonymous() {
        return false;
    }

    public String getMockUrl() {
        return this.requestUrl;
    }

    @Override
    public Map<String, Class<?>> getParameterInfo() {
        LinkedHashMap info = new LinkedHashMap();
        for (DWMockParameter parameter : this.parameters) {
            info.put(parameter.getName(), parameter.getValueType());
        }
        return info;
    }

    @Override
    public boolean isMatch(DWParameters parameters) {
        String[] parameterNames;
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (DWMockParameter item : this.parameters) {
            nameList.add(item.getName());
        }
        if (this.parameters.size() != parameters.getCount().intValue()) {
            return false;
        }
        for (String name : parameterNames = parameters.getNames()) {
            if (!nameList.contains(name)) {
                return false;
            }
            nameList.remove(name);
        }
        return true;
    }

    @Override
    public Object invoke(Object service, DWParameters parameters) throws Exception {
        if (!this.mockDatas.isEmpty()) {
            return this.mockDatas.get(0).getOutput();
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Url(").append(this.requestUrl).append("), ");
        result.append("Signature(");
        ArrayList<String> parameterInfos = new ArrayList<String>();
        for (DWMockParameter mockParameter : this.parameters) {
            parameterInfos.add(mockParameter.toString());
        }
        result.append(String.join((CharSequence)", ", parameterInfos));
        result.append(")");
        result.append(", mock datas=(");
        int i = 1;
        for (DWMockData mockData : this.mockDatas) {
            result.append("[");
            result.append(i++).append(".").append(mockData.toString());
            result.append("]");
        }
        result.append(")");
        return result.toString();
    }
}

