/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.mock;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceRepository;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.container.local.mock.DWMockHeader;
import com.digiwin.app.container.local.mock.DWMockInfoProvider;
import com.digiwin.app.container.local.mock.DWMockService;
import com.digiwin.app.container.local.mock.DWMockServiceImp;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.DWServiceLocationInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DWMockHeaderServiceRepository
implements DWHeaderRepository,
DWServiceRepository {
    private DWMockInfoProvider mockInfoProvider;
    private List<DWHeader> mockHeaders = new ArrayList<DWHeader>();
    private DWMockService mockService = new DWMockServiceImp();

    public DWMockHeaderServiceRepository(DWMockInfoProvider mockInfoProvider) {
        if (mockInfoProvider == null) {
            throw new IllegalArgumentException("mockInfoProvider is null!");
        }
        this.mockInfoProvider = mockInfoProvider;
        this.initialize();
    }

    private void initialize() {
        DWMockHeader[] headers = this.mockInfoProvider.getMockHeaders();
        this.mockHeaders = Arrays.asList(headers);
    }

    @Override
    public DWService getService(DWHeader header, DWMethod method) throws Exception {
        if (this.mockHeaders.contains(header)) {
            return this.mockService;
        }
        return null;
    }

    @Override
    public Map<String, List<DWServiceInfo>> getServiceInfos() {
        return new HashMap<String, List<DWServiceInfo>>();
    }

    @Override
    public List<DWServiceInfo> getServiceInfos(String groupName) {
        return new ArrayList<DWServiceInfo>();
    }

    @Override
    public DWServiceInfo getServiceInfo(String groupName, String serviceName) {
        return null;
    }

    @Override
    public List<DWHeader> getAllHeader() {
        return this.mockHeaders;
    }

    @Override
    public void refresh(String moduleName) throws Exception {
        this.initialize();
    }

    @Override
    public List<DWHeader> getHeaders(String moduleName) {
        ArrayList<DWHeader> result = new ArrayList<DWHeader>();
        for (DWHeader header : this.mockHeaders) {
            if (!StringUtils.equals((CharSequence)header.getModuleName(), (CharSequence)moduleName)) continue;
            result.add(header);
        }
        return result;
    }

    @Override
    public DWHeader getHeader(String groupName, String serviceName) {
        return null;
    }

    @Override
    public DWTargetAPI getAPI(DWServiceLocationInfo locationInfo) {
        return null;
    }
}

