/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRegistry;
import com.digiwin.app.container.DWServiceRegistry;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWServiceDefinitionParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class DWAbstractServiceDefinitionParser<H extends DWHeader>
implements DWServiceDefinitionParser {
    protected DWHeaderRegistry<H> headerRepository;
    protected DWServiceRegistry serviceRepository;

    public DWAbstractServiceDefinitionParser(DWHeaderRegistry<H> headerRepository, DWServiceRegistry serviceRepository) {
        this.headerRepository = headerRepository;
        this.serviceRepository = serviceRepository;
    }

    @Override
    public void parseInterface(Map<String, List<Class<?>>> interfaceClassList) {
        Objects.requireNonNull(interfaceClassList);
        interfaceClassList.forEach(this::parseInterface);
    }

    @Override
    public void parseImplementation(Map<String, List<DWServiceInfo>> implementationClassList) {
        Objects.requireNonNull(implementationClassList);
        implementationClassList.forEach(this::parseImplementation);
    }

    protected void registerHeader(String groupName, List<H> headers) {
        this.headerRepository.register(groupName, headers);
    }

    protected void registerService(String groupName, List<DWServiceInfo> services) {
        this.serviceRepository.register(groupName, services);
    }
}

